'''Download PyTorch Imagenet to default root folder'''

from torchvision.datasets import ImageNet
from framework.config import get_config

import os

if __name__ == '__main__':
  config = get_config()
  print('==> Start downloading to {}..'.format(config['root']))
  trainset = ImageNet(root=os.path.join(
      config['root'], 'imagenet'), split='train', download=True)
  testset = ImageNet(root=os.path.join(
      config['root'], 'imagenet'), split='val', download=True)
  print('==> Download complete.')
