#   Computing the TD distance
#   data0 and data1 are the representations to compare, n * d, where n is the number of data and d is the dimension


import numpy as np
import pandas as pd

distance_all=0
dis1_all=0

data0=pd.read_csv('.../.csv', header=None)
data1=pd.read_csv('.../.csv', header=None)
print('data loaded')
distance=0
dis1=0
y_len=data0.shape[0]
predic0=np.zeros(y_len)
predic1=np.zeros(y_len)
for i in range(y_len):
    x0=np.array(data0)[i,:]
    x1=np.array(data1)[i,:]
    x0=np.exp(x0)/sum(np.exp(x0))
    x1=np.exp(x1)/sum(np.exp(x1))
    distance+=sum(abs(x0-x1))/2
    predic0[i]=np.argmax(x0)
    predic1[i]=np.argmax(x1)
    if predic0[i] != predic1[i]:
        dis1+=1
    
print('td_soft result:{}..'.format(distance/y_len))
print('td_hard result:{}..'.format(dis1/y_len))
