#!/bin/bash

net=cnn_3layer_small

# example of train script for PGD trained with backprop -- use this to train init networks
CUDA_VISIBLE_DEVICES=0 python mix_train.py \
        --dataset mnist --init default --use-pgd-training  \
        --net $net \
        --lr 0.0005 --L2-reg 0 --lr-milestones 50 60 \
        --train-eps 0.1 --test-eps 0.1  --train-steps 10 --test-steps 10  \
        --train-batch 256 --test-batch 256  \
        --robust-weight-start 1 --robust-weight-end 1 \
        --start-epoch-robust-weight 0 --end-epoch-robust-weight 0 \
        --grad-clip 10 \
        --n-epochs 70 --start-epoch-eps 0 --end-epoch-eps 20 \
        --save-dir ./SGD_models/

# example of train script for IBP loss trained with backprop
CUDA_VISIBLE_DEVICES=0 python mix_train.py \
        --dataset mnist --init default --use-vanilla-ibp  \
        --net $net \
        --lr 0.0005 --L2-reg 0 --lr-milestones 50 60 \
        --train-eps 0.1 --test-eps 0.1  --train-steps 10 --test-steps 10  \
        --train-batch 256 --test-batch 256  \
        --robust-weight-start 1 --robust-weight-end 1 \
        --start-epoch-robust-weight 0 --end-epoch-robust-weight 0 \
        --grad-clip 10 \
        --n-epochs 70 --start-epoch-eps 0 --end-epoch-eps 20 \
        --save-dir ./SGD_models/

# example of train script for DP loss trained with backprop
CUDA_VISIBLE_DEVICES=$gpu_idx python mix_train.py \
        --dataset mnist --init default --use-DP-training  \
        --net $net \
        --lr 0.0005 --L2-reg 0 --lr-milestones 50 60 \
        --train-eps $train_eps --test-eps 0.1  --train-steps 10 --test-steps 10  \
        --train-batch 128 --test-batch 128  \
        --robust-weight-start 1 --robust-weight-end 1 \
        --start-epoch-robust-weight 0 --end-epoch-robust-weight 0 \
        --grad-clip 10 \
        --n-epochs 70 --start-epoch-eps 0 --end-epoch-eps 20 \
        --save-dir ./SGD_models/