#!/bin/bash

## PGPE from pretrain with IBP Loss
BS=512
lr=3e-4
net=cnn_3layer_small
CUDA_VISIBLE_DEVICES=0,1 python evo_train.py --use-PGPE-evo \
       --dataset mnist --init default --use-vanilla-ibp --load-model SGD_models/mnist/eps0.1/PGD_trained/$net/init_default/model.ckpt --subbatch-size 512 \
       --popsize 256 --std-init 1e-3 --std-min 1e-5 --num-actors 4 \
       --use-small-box --eps-shrinkage 0.05 \
       --net $net \
       --lr $lr --L2-reg 0 --lr-milestones 110 130 --lr-decay-factor 0.4 \
       --train-eps 0.1 --test-eps 0.1  --train-steps 0 --test-steps 0  \
       --train-batch $BS --test-batch 50  \
       --robust-weight-start 1 --robust-weight-end 1 \
       --start-epoch-robust-weight 0 --end-epoch-robust-weight 0 \
       --grad-clip 10 \
       --n-epochs 150 --start-epoch-eps 0 --end-epoch-eps 40 --eps-start 0.01 --schedule linear \
       --save-dir ./test_models/

## PGPE from pretrain with DP Loss
BS=512
lr=3e-4
net=cnn_3layer_small
CUDA_VISIBLE_DEVICES=0,1,2,3,4,5,6,7 python evo_train.py --use-PGPE-evo \
       --dataset mnist --init default --use-DP-training --load-model SGD_models/mnist/eps0.1/PGD_trained/$net/init_default/model.ckpt --subbatch-size 128 \
       --popsize 256 --std-init 1e-3 --std-min 1e-5 --num-actors 8 \
       --use-small-box --eps-shrinkage 0.05 \
       --net $net --opt adam  \
       --lr $lr --L2-reg 0 --lr-milestones 110 130 --lr-decay-factor 0.4 \
       --train-eps 0.1 --test-eps 0.1  --train-steps 0 --test-steps 0  \
       --train-batch $BS --test-batch 50  \
       --robust-weight-start 1 --robust-weight-end 1 \
       --start-epoch-robust-weight 0 --end-epoch-robust-weight 0 \
       --grad-clip 10 \
       --n-epochs 150 --start-epoch-eps 0 --end-epoch-eps 50 --eps-start 0.01 --schedule linear \
       --save-dir ./test_models/

# BS=512
# lr=3e-4
# net=cnn_3layer_small
# ## PGPE from pretrain
# CUDA_VISIBLE_DEVICES=0,1,2,3,4,5,6,7 python evo_train.py --use-PGPE-evo \
#        --dataset mnist --init default --use-DP-training --load-model SGD_models/cifar10/eps2/PGD_trained/cnn_3layer_small/init_default/model.ckpt --subbatch-size 64 \
#        --popsize 256 --std-init 1e-3 --std-min 1e-5 --num-actors 8 \
#        --net $net \
#        --lr $lr --L2-reg 0 --lr-milestones 110 130 --lr-decay-factor 0.4 \
#        --train-eps 0.1 --test-eps 0.1  --train-steps 0 --test-steps 0  \
#        --train-batch $BS --test-batch 50  \
#        --robust-weight-start 1 --robust-weight-end 1 \
#        --start-epoch-robust-weight 0 --end-epoch-robust-weight 0 \
#        --grad-clip 10 \
#        --n-epochs 150 --start-epoch-eps 0 --end-epoch-eps 0 \
#        --save-dir ./test_models/
#        # --use-small-box --eps-shrinkage 0.05 \

# BS=512
# lr=3e-4
# net=cnn_5layer_evo
# ## PGPE from pretrain
# CUDA_VISIBLE_DEVICES=0,1,2,3,4,5,6,7 python evo_train.py --use-PGPE-evo \
#        --dataset mnist --init default --use-DP-training --load-model SGD_models/mnist/eps0.1/PGD_trained/$net/init_default/model.ckpt --subbatch-size 16 \
#        --popsize 256 --std-init 1e-3 --std-min 1e-5 --num-actors 8 \
#        --net $net \
#        --lr $lr --L2-reg 0 --lr-milestones 110 130 --lr-decay-factor 0.4\
#        --train-eps 0.1 --test-eps 0.1  --train-steps 0 --test-steps 0  \
#        --train-batch $BS --test-batch 50  \
#        --robust-weight-start 1 --robust-weight-end 1 \
#        --start-epoch-robust-weight 0 --end-epoch-robust-weight 0 \
#        --grad-clip 10 \
#        --n-epochs 150 --start-epoch-eps 0 --end-epoch-eps 0 \
#        --save-dir ./test_models/

# BS=512
# lr=5e-5
# ## PGPE from pretrain
# CUDA_VISIBLE_DEVICES=0,1,2,3,4,5,6,7 python evo_train.py --use-PGPE-evo \
#        --dataset mnist --init default --use-DP-training --load-model SGD_models/mnist/eps0.1/PGD_trained/cnn_3layer_small/init_default/model.ckpt --subbatch-size 100 \
#        --popsize 64 --std-init 1e-3 --std-min 1e-5 --num-actors 8 \
#        --net cnn_3layer_small \
#        --lr $lr --L2-reg 0 --lr-milestones 110 130 --lr-decay-factor 0.4\
#        --train-eps 0.1 --test-eps 0.1  --train-steps 0 --test-steps 0  \
#        --train-batch $BS --test-batch 50  \
#        --robust-weight-start 1 --robust-weight-end 1 \
#        --start-epoch-robust-weight 0 --end-epoch-robust-weight 0 \
#        --grad-clip 10 \
#        --n-epochs 150 --start-epoch-eps 0 --end-epoch-eps 0 \
#        --save-dir ./test_models/

# BS=128
# lr=2e-4
# ## PGPE from pretrain
# CUDA_VISIBLE_DEVICES=0,1,2,3,4,5,6,7 python evo_train.py --use-PGPE-evo \
#        --dataset mnist --init default --use-DP-training --load-model SGD_models/mnist/eps0.1/PGD_trained/cnn_3layer_small/init_default/model.ckpt --subbatch-size 100 \
#        --popsize 256 --std-init 1e-3 --std-min 1e-5 --num-actors 8 \
#        --net cnn_3layer_small \
#        --lr $lr --L2-reg 0 --lr-milestones 52 \
#        --train-eps 0.1 --test-eps 0.1  --train-steps 0 --test-steps 0  \
#        --train-batch $BS --test-batch 50  \
#        --robust-weight-start 1 --robust-weight-end 1 \
#        --start-epoch-robust-weight 0 --end-epoch-robust-weight 0 \
#        --grad-clip 10 \
#        --n-epochs 65 --start-epoch-eps 0 --end-epoch-eps 0 \
#        --save-dir ./test_models/

# BS=64
# lr=4e-4
# ## PGPE from pretrain
# CUDA_VISIBLE_DEVICES=0,1,2,3,4,5,6,7 python evo_train.py --use-PGPE-evo \
#        --dataset mnist --init default --use-DP-training --load-model SGD_models/mnist/eps0.1/PGD_trained/cnn_3layer_small/init_default/model.ckpt --subbatch-size 100 \
#        --popsize 256 --std-init 1e-3 --std-min 1e-5 --num-actors 8 \
#        --net cnn_3layer_small \
#        --lr $lr --L2-reg 0 --lr-milestones 30 \
#        --train-eps 0.1 --test-eps 0.1  --train-steps 0 --test-steps 0  \
#        --train-batch $BS --test-batch 50  \
#        --robust-weight-start 1 --robust-weight-end 1 \
#        --start-epoch-robust-weight 0 --end-epoch-robust-weight 0 \
#        --grad-clip 10 \
#        --n-epochs 50 --start-epoch-eps 0 --end-epoch-eps 0 \
#        --save-dir ./test_models/

# BS=1024
# lr=1e-4
# ## PGPE from pretrain
# CUDA_VISIBLE_DEVICES=0,1,2,3,4,5,6,7 python evo_train.py --use-PGPE-evo \
#        --dataset mnist --init default --use-DP-training --load-model SGD_models/mnist/eps0.1/PGD_trained/cnn_3layer_small/init_default/model.ckpt --subbatch-size 100 \
#        --popsize 256 --std-init 1e-3 --std-min 1e-5 --num-actors 8 \
#        --net cnn_3layer_small \
#        --lr $lr --L2-reg 0 --lr-milestones 30 \
#        --train-eps 0.1 --test-eps 0.1  --train-steps 0 --test-steps 0  \
#        --train-batch $BS --test-batch 50  \
#        --robust-weight-start 1 --robust-weight-end 1 \
#        --start-epoch-robust-weight 0 --end-epoch-robust-weight 0 \
#        --grad-clip 10 \
#        --n-epochs 50 --start-epoch-eps 0 --end-epoch-eps 0 \
#        --save-dir ./test_models/

