#!/bin/bash

BS=32
lr=5e-4
net=cnn_5layer_evo

eps=0.1

pw=0
popsize=2
GSM_popsize=2 # GSM popsize means RGS popsize

CUDA_VISIBLE_DEVICES=0,1,2,3,4,5,6,7 python ./evo_train_new.py --use-Mixed-evo \
        --dataset mnist --init default --use-DP-training --subbatch-size $BS \
        --load-model SGD_models/mnist/eps$eps/PGD_trained/$net/init_default/model.ckpt \
        --popsize $popsize --GSM-popsize $GSM_popsize --std-init 1e-3 --std-min 1e-5 --num-actors 8 \
        --PGPE-weight $pw \
        --net $net --opt adam \
        --L1-reg 0 --fast-reg 0.5 \
        --lr $lr --lr-std 0 --L2-reg 0 --lr-milestones 40 50 --lr-decay-factor 0.4 \
        --train-eps $eps --test-eps $eps --train-steps 0 --test-steps 0 \
        --train-batch $BS --test-batch $BS \
        --robust-weight-start 1 --robust-weight-end 1 \
        --start-epoch-robust-weight 0 --end-epoch-robust-weight 0 \
        --grad-clip 10 --dist-sampler-train \
        --n-epochs 60 --start-epoch-eps 0 --end-epoch-eps 0 \
        --save-dir ./test_models/ --neptune-tags cifar_s Mixed GSM_$GSM_popsize DP PGDi

# eps=0.3

# pw=0
# popsize=2
# GSM_popsize=2 # GSM popsize means RGS popsize

# CUDA_VISIBLE_DEVICES=0,1,2,3,4,5,6,7 python ./evo_train_new.py --use-Mixed-evo \
#         --dataset mnist --init default --use-DP-training --subbatch-size $BS \
#         --load-model SGD_models/mnist/eps$eps/PGD_trained/$net/init_default/model.ckpt \
#         --popsize $popsize --GSM-popsize $GSM_popsize --std-init 1e-3 --std-min 1e-5 --num-actors 8 \
#         --PGPE-weight $pw \
#         --net $net --opt adam \
#         --L1-reg 0 --fast-reg 0.5 \
#         --lr $lr --lr-std 0 --L2-reg 0 --lr-milestones 60 70 --lr-decay-factor 0.4 \
#         --train-eps $eps --test-eps $eps --train-steps 0 --test-steps 0 \
#         --train-batch $BS --test-batch $BS \
#         --robust-weight-start 1 --robust-weight-end 1 \
#         --start-epoch-robust-weight 0 --end-epoch-robust-weight 0 \
#         --grad-clip 10 --dist-sampler-train \
#         --n-epochs 80 --start-epoch-eps 0 --end-epoch-eps 20 \
#         --save-dir ./test_models/ --neptune-tags cifar_s Mixed GSM_$GSM_popsize DP PGDi
