# Optimized Linear Measurements for Inverse Problems using Diffusion-Based Image Generation
NeurIPS 2024 Submission 9890

## Installation and Setup

### Python Environment: 
```
python -m venv denoiser-recon
source denoiser-recon/bin/activate
pip install -r requirements.txt
```

### Dataset and Results:
Download the dataset and result files from the anonymized OSF link:
https://osf.io/eymtv/?view_only=44f6dba4ef504de3b41896de117e799d
- Unzip and put the dataset files (celeba_gray.npy.zip) under ./utils/dataset/celeba
- Unzip the result files (optimal measurement matrices; olm_result.zip) under the project root directory.

## Run Notebook examples under /notebooks (move them to project root directory before running)
- 0_denoise_prior: Unconditional samples from our trained denoisers.
- 1_bivariate: Optimal measurement for bivariate examples.
- 2_example: Conditional samples from denoiser based on linear measurements.
- 3_psnr: Evaluate and compare performance of different linear measurements.
- 4_linear_subspace: Analysis and visualize linear measurement subspace.
- 5_ssim: Optimizing the linear measurements wrt the SSIM objective.

For computing the Optimized Linear Measurements, see lnopt_run.sh