# 设置模型参数
gpu=0
model="GRformer"
seq_len=336
loss="huber"
# RNN类别
rnn=2
# 图卷积类别
gcn=2
subgraph_size=2
gcn_depth=2

if [ "$model" = "GRformer" ]; then
    if [ $rnn -gt 0 ]; then
        if [ $gcn -gt 0 ]; then
            model_name="RPGformer"
        else
            model_name="RPformer"
        fi
    else
        if [ $gcn -gt 0 ]; then
            model_name="PGformer"
        else
            model_name="PatchTST"
        fi
    fi
fi

# 设置数据参数
dataset_name="ETTh1"

if [ "$dataset_name" = "weather" ]; then
    root_path=data/weather
    data_path="${dataset_name}.csv"
    dataset_type=custom
    enc_in=21
elif [ "$dataset_name" = "electricity" ]; then
    root_path=data/electricity
    data_path="${dataset_name}.csv"
    dataset_type=custom
    enc_in=321
elif [ "$dataset_name" = "traffic" ]; then
    root_path=data/traffic
    data_path="${dataset_name}.csv"
    dataset_type=custom
    enc_in=862
elif [ "$dataset_name" = "ETTh1" ] || [ "$dataset_name" = "ETTh2" ]; then
    root_path=data/ETT-small
    data_path="${dataset_name}.csv"
    dataset_type=ETTh1
    enc_in=7
elif [ "$dataset_name" = "ETTm1" ] || [ "$dataset_name" = "ETTm2" ]; then
    root_path=data/ETT-small
    data_path="${dataset_name}.csv"
    dataset_type=ETTm1
    enc_in=7
elif [ "$dataset_name" = "ILI" ]; then
    root_path=data/illness
    data_path="national_illness.csv"
    dataset_type=custom
    enc_in=7
fi
random_seed=2023

# RNN命名赋值
if [ $rnn -eq 2 ]; then
    rnn_str="-RNN"
elif [ $rnn -eq 1 ]; then
    rnn_str="-LR"
else
    rnn_str=""
fi
# GCN命名赋值
if [ $gcn -eq 2 ]; then
    mlp_str="custom"
elif [ $gcn -eq 1 ]; then
    mlp_str="ln"
else
    mlp_str="gc"
fi

# for pred_len in 96 192 336 720
# for pred_len in 96 192
for pred_len in 336 720
# for pred_len in 24 36 48 60
do
    if [ $gcn -eq 0 ]; then
        log_file="/home/hirisun/RPGformer/${dataset_name}_${seq_len}_${pred_len}_${model_name}_${loss}-lr${rnn_str}.log"
        nohup python main.py \
        --gpu=$gpu \
        --model=$model \
        --seq_len=$seq_len \
        --pred_len=$pred_len \
        --loss=$loss \
        --rnn=$rnn \
        --dataset_name=$dataset_name \
        --data_path=$data_path \
        --root_path=$root_path \
        --dataset_type=$dataset_type \
        --enc_in=$enc_in \
        > $log_file 2>&1 &
    else
        log_file="/home/hirisun/RPGformer/${dataset_name}_${seq_len}_${pred_len}_${model_name}_${loss}-lr${rnn_str}-${subgraph_size}+${gcn_depth}${mlp_str}.log"
        nohup python main.py \
        --gpu=$gpu \
        --model=$model \
        --seq_len=$seq_len \
        --pred_len=$pred_len \
        --loss=$loss \
        --rnn=$rnn \
        --use_gcn \
        --mlp_type=$gcn \
        --subgraph_size=$subgraph_size \
        --gcn_depth=$gcn_depth \
        --dataset_name=$dataset_name \
        --data_path=$data_path \
        --root_path=$root_path \
        --dataset_type=$dataset_type \
        --enc_in=$enc_in \
        > $log_file 2>&1 &
    fi
    gpu=$(($gpu+1))
done