# Uncovering the Spectrum of Graph Generative Models: From One-Shot to Sequential

This is the code which was used to run the experiments for the paper "Uncovering the Spectrum of Graph Generative Models: From One-Shot to Sequential". This repository should be anomyous for the double-blind review process. The code will be made public after the review process.

## Requirements

The code was tested with Python 3.10.4, PyTorch 1.13.1 and Torch Geometric 2.2.0. The requirements can be installed with the following commands:
- Download anaconda/miniconda if needed
- Create a new conda environment with the following command:
    ```bash
    conda create -c conda-forge -n ifh-gen rdkit=2023.03.2 python=3.10.4
    ```
- Activate the environment with the following command:
    ```bash
    conda activate ifh-gen
    ```
- Install the cuda toolkit with the following command (we used 11.7.0):
    ```bash
    conda install -c "nvidia/label/cuda-11.7.0" cuda
    ```
- Install PyTorch with the following command (we used 1.13.1):
    ```bash
    pip3 install torch==1.13.1 --index-url https://download.pytorch.org/whl/cu117
    ```
- Install Torch Geometric with the following command (we used 2.2.0):
    ```bash
    pip install torch_geometric==2.2.0
    ```
- Install the auxiliary libraries for PyG:
    ```bash
    pip install torch_scatter torch_sparse torch_cluster torch_spline_conv -f https://data.pyg.org/whl/torch-1.13.0+cu117.html
    ```
- Install EDeN with the following command:
    ```bash
    pip install git+https://github.com/fabriziocosta/EDeN.git --user
    ```
- Install the other requirements with the following command:
    ```bash
    pip install -r requirements.txt
    ```
- Install the package with the following command:
    ```bash
    pip install -e .
    ```
- Navigate the directory ./src/metrics/utils/orca and compile the orca executable with the following command:
    ```bash
    g++ -O2 -std=c++11 -o orca orca.cpp
    ```

## Experiments
All the configurations of the experiments can be found at ./src/configs/battery. The experiments can be run with different seeds with the following command:
```bash
    python main.py "+battery/<dataset>=<experiment>" "seed=<seed>"
```
where \<dataset\> is the name of the dataset, \<experiment\> is the name of the experiment and \<seed\> is the seed to use for the experiment. For example, to run the experiment "exp4_one_zinc" on the dataset "zinc" with the seed 2, the following command can be used:
```bash
    python main.py "+battery/zinc=exp4_one_zinc" "seed=2"
```

## Datasets
Datasets will be downloaded automatically to a new directory ./datasets when running the experiments.

## Checkpoints and logging
Checkpoints are saved in a new directory ./checkpoints, and logging is done through WandB, which requires a free account to be used.