import hydra
# for some reasons the pandas import is required,
# as it goes in conflict with torch_geometric
import pandas
from omegaconf import DictConfig, OmegaConf, open_dict
from src.configurator import RunContext, preprocess_config
from hydra.core.hydra_config import HydraConfig


@hydra.main(version_base=None, config_path='configs', config_name='default')
def main(cfg: DictConfig):

    # make hydra config available in the current config
    # will be removed later
    OmegaConf.set_struct(cfg, True)
    with open_dict(cfg):
        cfg.hydra = HydraConfig.get()


    # prepare context with data, model, trainer, etc.
    context: RunContext = RunContext.from_config(cfg)
    
    # train model
    context.fit()

    if not context.debug:
        # evaluate model
        context.evaluate_all_checkpoints()

    context.close()


if __name__ == '__main__':
    main()