# Optimal Resource Allocation for Early Stopping-based Neural Architecture Search Methods
*by Marcel Aach, Eray Inanc, Rakesh Sarma, Morris Riedel, Andreas Lintermann*

This repository contains the code and the batch scripts for reproducing the results of the paper "Optimal Resource Allocation for Early Stopping-based Neural Architecture Search Methods", accepted at the AutoML Conference 2023.

The code is based on the Ray Tune framework, which was installed and run on SLURM-based HPC machines, e.g. with a setup of 4 GPUs per node. Some python libraries (such as ray) were installed inside a pip environment, but some libraries were loaded from the HPC machine. Apart from the pip installed libraries in the "requirements.txt" file, the following frameworks are necessary and need to be installted or loaded from the HPC machine:  

```
- CUDA-11.5 
- PyTorch/1.11
- torchvision/0.12.0
- OpenMPI/4.1.2 
```


The python code for replicating the single GPU runs is located in the single_gpu_run.py and while the code for the multi GPU runs is located in the multi_gpu_run.py file. Both need the respective files from NATS-Bench. The following flags can be set to specify which version to run:

## For the single GPU case:

--num-samples = [64, 128] (Total number of samples to evaluate, depending on the experiment)<br>
--par-workers = [1,2,4,8] (number of parallel trials to run on the GPU)<br>
--scheduler = [ASHA, BOHB, HB, RAND] (type of scheduler to use for NAS)<br>
--dataset = [cifar-10, cifar-100, imagenet-16] (type of dataset from NATSBench to use for NAS)<br>
--seed = [111,222,333] (random seed)<br>
--scale-bs = [0,1] (wether to scale the batch size with the number of workers)<br>

## For the multi GPU case:

--num-samples = [64, 128, 256] (Total number of samples to evaluate, depending on the experiment)<br>
--par-workers = [1,2,4,8] (number of parallel trials to run on the GPU)<br>
--scheduler = [ASHA, BOHB, HB, RAND] (type of scheduler to use for NAS)<br>
--dataset = [cifar-10, cifar-100, imagenet-16] (type of dataset from NATSBench to use for NAS)<br>
--seed = [111,222,333] (random seed)<br>

We also include the batch script, required to submit the jobs to the JURECA-DC-GPU system, located at the Jülich Supercomputing Centre in Germany.  

### Citation

If you find this work helpful, please cite our paper: