PEML: Parameter-efficient Multi-Task Learning with Optimized Continuous Prompts
==========================

This project integrates a PrefixNAS module into the HuggingFace PEFT library
and performs multi-task fine-tuning using Ray Tune with the T5-large model on the SuperGLUE benchmark.

--------------------------------------------------------------------------------

Project Structure:
------------------
.
├── search_SG.py               # Training and hyperparameter tuning script
├── custom/model.py            # Custom PrefixNAS model
├── requirements.txt           # Python dependencies
└── README.txt                 # Setup and usage guide

--------------------------------------------------------------------------------

Installation & Setup:
---------------------

1. Unzip the Repository
-----------------------

2. (Optional) Create a Virtual Environment
------------------------------------------
python -m venv venv
source venv/bin/activate

3. Install Python Dependencies
------------------------------
pip install -r requirements.txt

--------------------------------------------------------------------------------

Replace PEFT’s Prefix Tuning with PrefixNAS:
--------------------------------------------

4. Locate the PEFT Installation Path
------------------------------------
python -c "import peft; print(peft.__file__)"

Example output:
/home/username/.local/lib/python3.10/site-packages/peft/__init__.py

5. Replace PEFT’s model.py
--------------------------
cd /home/username/.local/lib/python3.10/site-packages/peft/tuners/prefix_tuning/

Backup the original:
cp model.py model_backup.py

Replace with your PrefixNAS:
cp /path/to/your/custom/model.py ./model.py

IMPORTANT: Your custom model.py must implement PEFT-compatible PrefixTuningConfig logic.

6. (If using multiple machines)
-------------------------------
Copy the custom model.py to each Ray worker node:
scp /path/to/your/custom/model.py user@worker-node:/home/username/.local/lib/python3.10/site-packages/peft/tuners/prefix_tuning/

--------------------------------------------------------------------------------

Running the Code:
-----------------

7. Start the Ray Cluster
------------------------

On the HEAD node:
ray start --head --num-gpus=8 --port=6379 --temp-dir=/tmp/my_temp

On each WORKER node:
ray start --address='<head_node_ip>:6379' --num-gpus=8 --temp-dir=/tmp/my_temp

8. Run the Training Script
--------------------------
python search_SG.py

Or in the background:
nohup python search_SG.py > search_only.txt &

--------------------------------------------------------------------------------


Outputs:
--------

- Checkpoints saved in: ./checkpoint/
- Evaluation logs: log.txt
- Saved models: /location/User_name/s_model/

--------------------------------------------------------------------------------

Troubleshooting:
----------------

- Ensure all nodes use the updated model.py.
- Restart the Ray cluster after modifying PEFT.
- If PEFT is updated via pip, you may need to reapply the model.py patch.

--------------------------------------------------------------------------------
Evaluation Results:
-------------------

PEFT Techniques | BoolQ   | RTE    | COPA   | MultiRC | WIC    | WSC    | Avg    
----------------|---------|--------|--------|---------|--------|--------|--------
PEML            | 0.9340  | 0.9317 | 0.8250 | 0.9043  | 0.8701 | 0.7500 | 0.8692 
