# MobileSafetyBench

![main_figure](./asset/figures/main_figure.png)

MobileSafetyBench can serve as a testbed for evaluating the safety and helpfulness of mobile device control agents.

## Setting

Setting MobileSafetyBench requires installing Android emulators and MobileSafetyBench environments.     


### Virtual environments
```
conda create -n mobile_safety python=3.10

echo "export MOBILE_SAFETY_HOME=/path/to/current/directory" >> ~/.bashrc
source ~/.bashrc
conda activate mobile_safety
```

```
pip install -r requirements.txt # install packages
pip install -e . # install mobile_safety 
```


### Android emulators (Android Studio)

```
# Install Open SDK 
sudo apt update 
sudo apt-get install adb
sudo add-apt-repository ppa:linuxuprising/java

sudo apt-get install openjdk-17-jdk
sudo update-alternatives --config java 
# set to /usr/lib/jvm/java-17-openjdk-amd64/bin/java
java -version 

# Install SDK manager 
# you can find this file at https://developer.android.com/studio/index.html#downloads 
sudo wget --no-check-certificate https://dl.google.com/android/repository/commandlinetools-linux-10406996_latest.zip 

export ANDROID_SDK_ROOT=$HOME/.local/share/android/sdk
mkdir -p $ANDROID_SDK_ROOT/cmdline-tools

sudo apt install unzip -y 
unzip commandlinetools-linux-10406996_latest.zip -d $ANDROID_SDK_ROOT/cmdline-tools 
mv $ANDROID_SDK_ROOT/cmdline-tools/cmdline-tools $ANDROID_SDK_ROOT/cmdline-tools/latest
echo "export PATH=$PATH:$ANDROID_SDK_ROOT/cmdline-tools/latest/bin:$ANDROID_SDK_ROOT/cmdline-tools/tools/bin" >> ~/.bashrc 
source ~/.bashrc

# Check sdkmanager version
sdkmanager --version
echo "DOWNLOAD ANDROID SDK DONE!"

# Configure sdkmanager
sdkmanager --licenses
sdkmanager --update --verbose

# Install Android Image version 34 
sdkmanager "emulator" 
sdkmanager "platform-tools" 
sdkmanager "platforms;android-34" 
sdkmanager "system-images;android-34;google_apis;x86_64" # for x86_64 architecture
# sdkmanager "system-images;android-34;google_apis;arm64-v8a" # for arm64-v8a architecture

# Check emulator version
echo "export PATH=$PATH:~/.local/share/android/sdk/emulator" >> ~/.bashrc 
source ~/.bashrc
emulator -version 
```

MobileSafetyBench is based on the Android operating system. 
Installing Android Studio is required to run each device environment in MobileSafetyBench, as our APIs interact with Android emulators.

### Appium

```
# Install NVM
wget -O install_nvm.sh https://raw.githubusercontent.com/nvm-sh/nvm/v0.35.2/install.sh
bash install_nvm.sh
rm -rf install_nvm.sh

nvm install v18.12.1

# Version check
node -v # v18.12.1
npm -v # 8.19.2

# Install appium
npm install -g appium # ver. 2.5.4 recommended
npm install wd
npm install -g appium-doctor
appium driver install uiautomator2

# Check appium installation
appium driver list --installed # uiautomator2 
appium -v # 2.x.x

# Set environment variable and check appium driver
echo “export JAVA_HOME=/usr/lib/jvm/java-17-openjdk-amd64” >> ~/.bashrc 
echo “export ANDROID_SDK_ROOT=$HOME/.local/share/android/sdk” >> ~/.bashrc 
echo "export APPIUM_BIN=$(which appium)" >> ~/.bashrc
source ~/.bashrc
```

The task success detector uses a combination of tools, including Appium. 
Installing Appium is required to evaluate several tasks effectively, ensuring automated interactions and UI element verifications.


### APK download

MobileSafetyBench extends tasks with third-party apps, requiring the installation of those apps. 
The third-party applications can be installed either via the app store in the emulator (manually) or using Android Debug Bridge (ADB) commands with downloaded APKs. 
We provide an automated process for installing the third-party apps with downloaded APKs in initialization pipeline.

Downloading and installing additional APK files for the third-party applications are required, to reproduce environments in our experiments. 
Please download the APK files with the specific versions described in ```asset/environments/apk_versions.txt```. After downloading, rename the APK files according to the version names specified in ```asset/environments/apk_versions.txt``` before placing them in ```asset/environments/resource/apks```. Then, proceed to install the MobileSafetyBench environments.


### AVD installation

MobileSafetyBench is implemented on an Android emulator. To achieve this, you need to install an Android Virtual Device (AVD).

Before installation, you need to adjust the settings based on the architecture of your CPU.\
In `asset/environments/config/device_property.json`, if you are using arm64-v8a, change the `system_image` to `system-images;android-34;google_apis;arm64-v8a`, and if you are using x86_64, change the `system_image` to `system-images;android-34;google_apis;x86_64`.
```
{
   "device_info": [
      {
         "device_id": "pixel_7",
         "device_code": 29,
         "physical_setting": [1080, 2400, 400],
         "icon_size": [330, 440, 550],
         "category": "pixel",
         "system_image": "system-images;android-34;google_apis;arm64-v8a"
      }
   ]
}
```
The script ```install.sh``` installs AVDs and saves snapshots by manipulating the icon size/location, wallpaper, and ohter settings.\
Each name of AVD (i.e., virtual device) is "pixel_7\_test\_{id}".\
To experiment with all tasks, install two or more AVDs with different IDs.
```
mkdir logs
bash install.sh
```
**Note** 
This installation for environments takes approximately an hour

After the installation, the screenshot of each environment is stored in ```logs/environment```.\
Users can also configure own environments by modifying files in ```asset/environments```


## Reference
Some codes are referred from the related work below:
- AndroidEnv (<a href="https://github.com/google-deepmind/android_env">link</a>)
- AppAgent (<a href="https://github.com/mnotgod96/AppAgent">link</a>)

## Licnese

MIT License
