# TRANSIC-Envs: Simulation Environments for Sim-to-Real Policy Transfer

## Table of Contents
1. [Installation](#Installation)
2. [Usage](#usage)

## Installation
First create a virtual environment named `transic` with Python 3.8. Note that IsaacGym only supports Python versions up to 3.8.

```bash
conda create -y -n transic python=3.8
conda activate transic
```

Download the IsaacGym Preview 4 release from the [website](https://developer.nvidia.com/isaac-gym), then follow the installation instructions in the documentation. Ensure that IsaacGym works on your system by running one of the examples from the `python/examples` directory, like `joint_monkey.py`.

Once IsaacGym works, install this codebase.
```bash
pip3 install -e .
```

## Usage

### Overview
To show all supported tasks, run
```python
import transic_envs
print(transic_envs.TASK_MAP.keys())

>>> ['InsertFull',
     'InsertFullPCD',
     'InsertSingle',
     'InsertSinglePCD',
     'LiftLeanedLeg',
     'LiftLeanedLegPCD',
     'ReachAndGraspFull',
     'ReachAndGraspFullPCD',
     'ReachAndGraspSingle',
     'ReachAndGraspSinglePCD',
     'ScrewFull',
     'ScrewFullPCD',
     'ScrewSingle',
     'ScrewSinglePCD',
     'Stabilize',
     'StabilizePCD']
```

|         Task          |                                                   Description                                                    |
|:---------------------:|:----------------------------------------------------------------------------------------------------------------:|
|      `Stabilize`      | Push the tabletop into the right corner of the wall such that it remains stable in the following assembly steps. |
| `ReachAndGraspSingle` |                                       Reach and grasp a single table leg.                                        |
|  `ReachAndGraspFull`  |                          Reach and grasp a table leg with other assembly parts present.                          |
|    `LiftLeanedLeg`    |   Lift a table leg leaned against the wall such that it aligns with gripper fingers for the ease of insertion.   |
|    `InsertSingle`     |                      Insert a pre-grasped table leg into the assembly hole of the tabletop.                      |
|     `InsertFull`      |     Insert a pre-grasped table leg into the assembly hole of the tabletop with other assembly parts present.     |
|     `ScrewSingle`     |                               Screw an inserted table leg into the assembly hole.                                |
|      `ScrewFull`      |              Screw an inserted table leg into the assembly hole with other assembly parts present.               |


### Observation Space and Action Space
Tasks without the `PCD` suffix are for teacher policy learning through RL. Tasks with the `PCD` suffix are for student policy distillation.
For teacher policies, the observation space includes proprioception and privileged information about objects, such as pose and velocity. For example:
```yaml
propObsDim: 29
obsKeys:
  - q
  - ...

privilegedObsDim: 130
privilegedObsKeys:
  - square_table_top_vel
  - ...
```
For student policies, the observation space only includes proprioception and point cloud. These are easily obtained in the real world.

In terms of the action space, teacher policies are trained with delta end-effector poses, while student policies are trained with joint positions, plus a binary gripper action for both.

```python
# teacher policy
Box(-1.0, 1.0, (7,), float32)

# student policy
Box(-1.0, 1.0, (8,), float32)
```