import esig.tosig
import torch


def setup(obj):
    obj.path = torch.rand(obj.size, dtype=torch.float).numpy()


def run(obj):
    first_result = esig.tosig.stream2sig(obj.path[0], obj.depth)
    if not len(first_result):
        raise Exception

    result = [first_result]
    for batch_elem in obj.path[1:]:
        result.append(esig.tosig.stream2sig(batch_elem, obj.depth))
    return result
