import iisignature
import torch


def setup(obj):
    obj.path = torch.rand(obj.size, dtype=torch.float).numpy()
    shape = obj.size[-3], iisignature.logsiglength(obj.size[-1], obj.depth)
    obj.grad = torch.rand(shape).numpy()
    obj.prepare = iisignature.prepare(obj.path.shape[-1], obj.depth)


def run(obj):
    return iisignature.logsigbackprop(obj.grad, obj.path, obj.prepare)
