import signatory
import torch


def setup(obj):
    obj.path = torch.rand(obj.size, dtype=torch.float, requires_grad=True, device='cuda')
    shape = obj.size[-3], signatory.logsignature_channels(obj.size[-1], obj.depth)
    obj.grad = torch.rand(shape, device='cuda')
    obj.logsignature = signatory.LogSignature(obj.depth)(obj.path)


def run(obj):
    obj.logsignature.backward(obj.grad, retain_graph=True)
    torch.cuda.synchronize()
    return obj.path.grad
