import signatory
import torch


def setup(obj):
    torch.set_num_threads(1)

    obj.path = torch.rand(obj.size, dtype=torch.float, requires_grad=True)
    shape = obj.size[-3], signatory.logsignature_channels(obj.size[-1], obj.depth)
    obj.grad = torch.rand(shape)
    obj.logsignature = signatory.LogSignature(obj.depth)(obj.path)


def run(obj):
    obj.logsignature.backward(obj.grad, retain_graph=True)
    return obj.path.grad
