import signatory
import torch


def setup(obj):
    obj.path = torch.rand(obj.size, dtype=torch.float, device='cuda')
    obj.logsignature_instance = signatory.LogSignature(obj.depth)
    obj.logsignature_instance.prepare(obj.size[-1])


def run(obj):
    result = obj.logsignature_instance(obj.path)
    torch.cuda.synchronize()
    return result
