import signatory
import torch


def setup(obj):
    obj.path = torch.rand(obj.size, dtype=torch.float, requires_grad=True, device='cuda')
    shape = obj.size[-3], signatory.signature_channels(obj.size[-1], obj.depth)
    obj.grad = torch.rand(shape, device='cuda')
    obj.signature = signatory.signature(obj.path, obj.depth)


def run(obj):
    obj.signature.backward(obj.grad, retain_graph=True)
    torch.cuda.synchronize()
    return obj.path.grad
