"""Performs time benchmarking on a particular operation.

This is pulled out in a separate process to work around an apparent PyTorch bug, that only allows for setting the number
of threads during the 'preamble', and not during the runtime of the program.
"""


import argparse
import importlib
import math
import sys
import timeit
import torch


def main():
    obj = argparse.Namespace(size=tuple(int(i) for i in size.split(',')), depth=int(depth))
    library_module = importlib.import_module('.functions.' + library_module_name, __package__)
    library_module.setup(obj)

    try:
        result = min(timeit.Timer(setup=lambda: library_module.run(obj),  # warm up
                                  stmt=lambda: library_module.run(obj)).repeat(repeat=50, number=1))
    except Exception:
        result = math.inf

    # Report results
    print(result)


# Perform setup
library_module_name, size, depth, device = sys.argv[1:]
device = int(device)
if device == -1:
    main()
else:
    with torch.cuda.device(device):
        main()
