// Provides for wrapping things into PyCapsules
 

#ifndef SIGNATORY_PYCAPSULE_HPP
#define SIGNATORY_PYCAPSULE_HPP

#include <torch/extension.h>


namespace signatory { namespace misc {
    // Makes an instance of a struct of type T and wraps it into a PyCapsule.
    template <typename T, typename ...Args>
    inline py::object wrap_capsule(Args&&... args);

    // Unwraps a capsule to give a struct of type T
    template <typename T>
    inline T* unwrap_capsule(py::object capsule);
}  /* namespace signatory::misc */ }  // namespace signatory

#include "pycapsule.inl"

#endif //SIGNATORY_PYCAPSULE_HPP
