 // Provides the basic signature computations


#ifndef SIGNATORY_SIGNATURE_HPP
#define SIGNATORY_SIGNATURE_HPP

namespace signatory {
    // Checks the arguments for the signature_forward function.
    void signature_checkargs(torch::Tensor path, s_size_type depth, bool basepoint, torch::Tensor basepoint_value,
                             bool initial, torch::Tensor initial_value, bool scalar_term);

    // See signatory.signature for documentation
    std::tuple<torch::Tensor, torch::Tensor>
    signature_forward(torch::Tensor path, s_size_type depth, bool stream, bool basepoint, torch::Tensor basepoint_value,
                      bool inverse, bool initial, torch::Tensor initial_value, bool scalar_term);

    // See signatory.signature for documentation
    std::tuple<torch::Tensor, torch::Tensor, torch::Tensor>
    signature_backward(torch::Tensor grad_signature, torch::Tensor signature, torch::Tensor path_increments,
                       s_size_type depth, bool stream, bool basepoint, bool inverse, bool initial, bool scalar_term);
}  // namespace signatory

#endif //SIGNATORY_SIGNATURE_HPP
