[ -z "${data_path}" ] && data_path='/datadisk'
[ -z "${data_path_list}" ] && data_path_list="oc20/s2ef/unref/2M"
[ -z "${data_path_list_valid}" ] && data_path_list_valid="oc20/s2ef/unref/all/val_id_20percent/"
[ -z "${save_dir}" ] && save_dir='./tmp' #'./amlt/probable-mule/e2former-oc20-Lin-2/' #
[ -z "${n_gpu}" ] && n_gpu=$(nvidia-smi -L | wc -l)
[ -z "${wandb_key}" ] && wandb_key="DUMMYKEY"
echo "n_gpu: ${n_gpu}"
 
export job_name=oc20-total-energy-False-8L-256Lmax4-bs4-8gpu-lr0.000075-drop0.05
wandb login --relogin --host=https://api.wandb.ai $wandb_key
export pbc_multigraph_cutoff=12
export batch_size=4
export hidden_size=256
export irreps_head_size=16
export layers=8
export lr=0.000075
export drop_path_rate=0.05




torchrun --standalone --nproc_per_node=1 main.py --num-gpus=$n_gpu --mode=train \
  --config-yml=./configs/s2ef/2M/EScAIP_hydra/L10_H8_512_e2former.yml   \
  --run-dir=$save_dir --logs-dir=$save_dir --timestamp-id=$job_name --logger=new_wandb \
    optim.load_balancing=None \
    optim.lr_initial=$lr \
      trainer=new_equiformerv2_forces model.backbone.use_compile=False \
      dataset.train.src=$data_path/$data_path_list \
      dataset.val.src=$data_path/$data_path_list_valid \
      dataset.train.train_on_oc20_total_energies=False \
      optim.batch_size=$batch_size \
      optim.eval_batch_size=$batch_size \
      model.heads.forces.module=src.E2Former.eSCN_ForceBlockV2 \
      model.heads.energy.module=src.E2Former.eSCN_EnergyBlock \
      model.backbone.encoder_embed_dim=$hidden_size \
      model.backbone.hidden_size=$hidden_size \
      model.backbone.num_layers=$layers \
      model.backbone.max_neighbors=16 \
      model.backbone.irreps_node_embedding="$hidden_size"x0e+"$hidden_size"x1e+"$hidden_size"x2e+"$hidden_size"x3e+"$hidden_size"x4e \
      model.backbone.irreps_head="$irreps_head_size"x0e+"$irreps_head_size"x1e+"$irreps_head_size"x2e+"$irreps_head_size"x3e+"$irreps_head_size"x4e \
      model.backbone.attn_scalar_head=$irreps_head_size \
      model.backbone.num_attn_heads=32 \
      model.backbone.number_of_basis=$hidden_size \
      model.backbone.pbc_max_radius=$pbc_multigraph_cutoff \
      model.backbone.max_radius=$pbc_multigraph_cutoff \
      model.backbone.alpha_drop=0.1 \
      model.backbone.drop_path_rate=$drop_path_rate \
      model.backbone.basis_type='gaussiansmear' \
      model.backbone.norm_layer='layer_norm_sh' \
      model.backbone.attn_type='all-order' \
      model.backbone.tp_type='dot_alpha' \
      model.backbone.edge_embedtype='default' \
      model.backbone.ffn_type='s2' \
      model.backbone.number_of_basis=$hidden_size \
      optim.eval_every=16000
 
 
     
 
