[ -z "${wandb_key}" ] && wandb_key='DUMMYKEY'
[ -z "${data_path}" ] && data_path='/data'
[ -z "${data_path_list}" ] && data_path_list="s2ef/all/train"
[ -z "${data_path_list_valid}" ] && data_path_list_valid="s2ef/all/train"
[ -z "${save_dir}" ] && save_dir='./tmp' #'./amlt/probable-mule/e2former-oc20-Lin-2/' #
[ -z "${n_gpu}" ] && n_gpu=$(nvidia-smi -L | wc -l)
echo "n_gpu: ${n_gpu}"



export job_name=oc22_lr_min_factor_0.35_LayerNormSH_bs16_12L256_lr2e-4-drop0.05LMax4_alphaDrop0.05_LMax3_energy_std_5
wandb login --relogin --host=https://api.wandb.ai $wandb_key
export pbc_multigraph_cutoff=12
export batch_size=4
export hidden_size=128
export irreps_head_size=16
export layers=6
export lr=0.0002
export drop_path_rate=0.05
export lr_min_factor=0.35





torchrun --standalone --nproc_per_node=1 main.py --num-gpus=$n_gpu --mode=train \
  --config-yml=./configs/oc22/s2ef/e2former/e2former.yaml \
  --run-dir=$save_dir --logs-dir=$save_dir --timestamp-id=$job_name --logger=new_wandb \
    optim.load_balancing=None \
    optim.lr_initial=$lr \
      trainer=new_equiformerv2_forces model.backbone.use_compile=False \
      dataset.train.src=$data_path/$data_path_list \
      dataset.val.src=$data_path/$data_path_list_valid \
      optim.batch_size=$batch_size \
      optim.eval_batch_size=$batch_size \
      model.heads.forces.module=src.E2Former.eSCN_ForceBlockV2 \
      model.heads.energy.module=src.E2Former.eSCN_EnergyBlock \
      model.backbone.encoder_embed_dim=$hidden_size \
      model.backbone.hidden_size=$hidden_size \
      model.backbone.num_layers=$layers \
      model.backbone.max_neighbors=16 \
      model.backbone.irreps_node_embedding="$hidden_size"x0e+"$hidden_size"x1e+"$hidden_size"x2e+"$hidden_size"x3e \
      model.backbone.irreps_head="$irreps_head_size"x0e+"$irreps_head_size"x1e+"$irreps_head_size"x2e+"$irreps_head_size"x3e \
      model.backbone.attn_scalar_head=$irreps_head_size \
      model.backbone.num_attn_heads=32 \
      model.backbone.number_of_basis=$hidden_size \
      model.backbone.pbc_max_radius=$pbc_multigraph_cutoff \
      model.backbone.max_radius=$pbc_multigraph_cutoff \
      model.backbone.alpha_drop=0.05 \
      model.backbone.drop_path_rate=$drop_path_rate \
      model.backbone.basis_type='gaussiansmear' \
      model.backbone.norm_layer='layer_norm_sh' \
      model.backbone.attn_type='all-order' \
      model.backbone.tp_type='dot_alpha' \
      model.backbone.edge_embedtype='default' \
      model.backbone.ffn_type='s2' \
      model.backbone.number_of_basis=$hidden_size \
      optim.eval_every=16000
 