import argparse


def weak_learner_args(parser):
    """General arguments for weak learners"""
    parser.add_argument(
        "--tree_type",
        default="CART",
        type=str,
        help="The type of tree to use",
        choices=["CART", "blossom"],
    )
    parser.add_argument(
        "--max_depth",
        type=int,
        default=1,
        help="Maximum depth of the decision trees",
    )
    parser.add_argument(
        "--crb",
        default="False",
        type=str2bool,
        help="To use confidence rated boosted trees",
    )
    return parser


def column_gen_args(parser):
    """Column generation arguments."""
    parser.add_argument(
        "--itermax",
        type=int,
        default=100,
        help="Maximum iterations for column generation",
    )
    parser.add_argument(
        "--obj_check",
        type=int,
        default=10,
        help="Number of iterations after which to check objective convergence",
    )
    parser.add_argument(
        "--obj_eps",
        type=float,
        default=1e-6,
        help="Objective convergence criterion for column generation",
    )
    parser.add_argument(
        "--check_dual_const",
        type=str2bool,
        default="False",
        help="To check the duality constraint at each new tree",
    )
    parser.add_argument(
        "--gurobi_time_limit",
        type=int,
        default=900,
        help="Time limit for a single iteration in seconds",
    )
    parser.add_argument(
        "--gurobi_num_threads",
        type=int,
        default=1,
        help="Number of threads reserved for gurobi",
    )
    return parser


def str2bool(text):
    text = text.lower()  # Convert input to lowercase for flexibility
    if text in ("true", "t", "1", "yes"):
        return True
    elif text in ("false", "f", "0", "no"):
        return False
    else:
        raise argparse.ArgumentTypeError(
            "Boolean value expected (True/False, 1/0, Yes/No)."
        )
