import argparse


def benchmark_args(parser):
    """Benchmark arguments."""
    parser.add_argument(
        "--benchmark",
        default="adaboost",
        type=str,
        help="The benchmark algorithm to use",
        choices=["adaboost", "xgboost", "lightgbm"],
    )
    parser.add_argument(
        "--run_benchmark",
        default="False",
        type=str2bool,
        help="To run benchmark algorithms instead of column generation",
    )

    return parser


def single_shot_args(parser):
    """Benchmark arguments."""
    parser.add_argument(
        "--run_single_shot",
        default="False",
        type=str2bool,
        help="To run single shot experiment instead of column generation",
    )

    return parser


def str2bool(text):
    text = text.lower()  # Convert input to lowercase for flexibility
    if text in ("true", "t", "1", "yes"):
        return True
    elif text in ("false", "f", "0", "no"):
        return False
    else:
        raise argparse.ArgumentTypeError(
            "Boolean value expected (True/False, 1/0, Yes/No)."
        )
