from src.parser import parse_args
import numpy as np
from src.column_generation import ColumnGenerator
from src.benchmarks import BenchmarkTrainer
from src.single_shot import SingleShotTrainer


def main():
    args = parse_args()
    np.random.seed(args.seed)

    if args.run_benchmark:
        trainer = BenchmarkTrainer(args)
    elif args.run_single_shot:
        trainer = SingleShotTrainer(args)
    else:
        trainer = ColumnGenerator(args)
    trainer.train()


if __name__ == "__main__":
    main()
