import argparse


def solver_type_args(parser):
    parser.add_argument(
        "--solver",
        type=str,
        default="neg_margins",
        choices=[
            "cg_boost",
            "erlp_boost",
            "lp_boost",
            "md_boost",
            "qrlp_boost",
            "neg_margins",
            "adaboost",
            "xgboost",
            "lightgbm",
        ],
        help="The method to solve the master problem",
    )
    return parser


def general_hyperparameter_args(parser):
    parser.add_argument(
        "--hyperparam", type=float, default=None, help="Hyperparameter"
    )
    return parser


def cgboost_args(parser):
    parser.add_argument("--F", type=float, default=0.01, help="Hyperparameter")
    return parser


def erlpboost_args(parser):
    parser.add_argument(
        "--G",
        type=float,
        default=1.0,
        help="Hyperparameter bounded by [1.0,num_samples]",
    )
    return parser


def lp_boost_args(parser):
    parser.add_argument(
        "--D",
        type=float,
        default=0.01,
        help="Hyperparameter, LPBoost performance is extremely sensitive to it",
    )
    return parser


def md_boost_args(parser):
    parser.add_argument("--C", type=float, default=10, help="Hyperparameter")
    parser.add_argument(
        "--delta",
        type=float,
        default=1e-15,
        help="Constant for Moore-Penrose pseudo-inverse A (too large may cause hard-to-solve models)",
    )
    parser.add_argument(
        "--use_identity_approx",
        type=str2bool,
        default="True",
        help="Use identity approximation of A when having a large datasets",
    )
    return parser


def qrlpboost_args(parser):
    parser.add_argument("--nu", type=float, default=0.1, help="Hyperparameter")
    return parser


def negmargin_args(parser):
    parser.add_argument("--E", type=float, default=0.1, help="Hyperparameter")
    return parser


def qp_args(parser):
    parser.add_argument(
        "--qp_tolerance",
        type=float,
        default=0.99,
        help="Stopping tolerance for solving quadratic programs iteratively",
    )
    return parser


def str2bool(text):
    text = text.lower()  # Convert input to lowercase for flexibility
    if text in ("true", "t", "1", "yes"):
        return True
    elif text in ("false", "f", "0", "no"):
        return False
    else:
        raise argparse.ArgumentTypeError(
            "Boolean value expected (True/False, 1/0, Yes/No)."
        )
