import argparse
from src.utils.parsers.columngen_parser import (
    weak_learner_args,
    column_gen_args,
)
from src.utils.parsers.general_parser import general_args
from src.utils.parsers.experiments_parser import (
    benchmark_args,
    single_shot_args,
)
from src.utils.parsers.solver_parser import (
    solver_type_args,
    general_hyperparameter_args,
    cgboost_args,
    erlpboost_args,
    qrlpboost_args,
    lp_boost_args,
    md_boost_args,
    negmargin_args,
    qp_args,
)


def parse_args():
    """Combine all argument categories into a single parser."""
    parser = argparse.ArgumentParser(
        description="Run decision trees and Gurobi for column generation"
    )
    parser = general_args(parser)
    parser = benchmark_args(parser)
    parser = single_shot_args(parser)
    parser = weak_learner_args(parser)
    parser = column_gen_args(parser)
    parser = solver_type_args(parser)
    parser = general_hyperparameter_args(parser)
    parser = cgboost_args(parser)
    parser = erlpboost_args(parser)
    parser = lp_boost_args(parser)
    parser = md_boost_args(parser)
    parser = qrlpboost_args(parser)
    parser = negmargin_args(parser)
    parser = qp_args(parser)

    return parser.parse_args()


if __name__ == "__main__":
    args = parse_args()
    print(args)
