
## introduction
This document lists the locations of our model components in the source code.
## Model
- **Model (i.e., ProDA):** Implemented as `GPNNMix4` in `myutils/extra_model.py`.

  It is initialized with the following parameters: `config`, `train_stage`, `flag`, `pre`, and `lt`.  
  The main parameters are `config` and `train_stage`; other parameters can use their default values.  

  - Use `train_stage=7` when training the full model.  
  - `config` can be left as the default. The config file is located at `configs/model.yaml`and is loaded using `configs/configs.py`.

  All submodules of the model are initialized in this module.
- **Backbone (i.e., video encoder):** Implemented as `MixTSE` in `myutils/extra_model.py`

- **VGPNN:** Implemented as `GPNN4` in `gpnn2/gpnn2.py`.

    The type of Normalization used is controlled by the `config.normtype`. `1` indicates the use of `BatchNorm`. `2` indicates the use of `GraphNorm`. `3` indicates the use of `VGNorm`. `5` indicates the use of `LayerNorm`.

    `config.gpnn.layer.one` Controls the number of VGPNN layers. Default is `3` indicates three layers.
- **VGNorm:** Implemented as `GlobalNorm3` in `gpnn2/gpnnutil.py`.
- **Prompt** 

    The type of prompt module used is controlled by the `config.prompt.type`. `0` indicates the use of `SimplePrompt`. `1` indicates the use of `DFM`.  
    - **DFM:** Implemented as `GPFPlus` in `myutils/gpfplus.py`.
    - **SimplePrompt:** Implemented as `SimplePrompt` in `myutils/gpfplus.py`.

## Loss Functions
All loss functions are implemented in `myutils/losses.py`.
- **AD Loss** consists of two components:  
  - **Disentanglement Loss**: Implemented as `SeparationLoss`  
  - **Reconstruction Loss**: Implemented as `ReconstructionLoss`
Both losses adopt a linear margin decay strategy based on the training epoch.

    - The maximum margin is controlled by:
        - `config.loss.spe.max_mar` (for Separation Loss)
        - `config.loss.rec.max_mar` (for Reconstruction Loss)

    - The current margin is controlled by:
        - `config.loss.spe.margin` (for Separation Loss)
        - `config.loss.rec.margin` (for Reconstruction Loss)
    - Loss weights are controlled by:
        - `config.loss.spe.weight` (for Separation Loss)
        - `config.loss.rec.weight` (for Reconstruction Loss)
- **Action Classification Loss**

    All classification losses are handled by the `Criterion` class in the same file.

    - For $a_s$, no additional weight parameter is used (i.e., loss weight is 1.).
    - For **a_t** and **a_u**, the loss weights are controlled by:
        - `config.loss.tot` (for $a_t$) 
        - `config.loss.pri` (for $a_u$)

## Training
Our training process consists of two stages

- **Stage 1 – Pre-training:** Trains the full network. 

  Implemented in `train/train_multigpu.py` via the `train_oracle` function.
- **Stage 2 – Post-training:** Fine-tunes the classifier.  
   Implemented in the same file via the `train_oracle_continue` function.

## Inference
We use functions from `/train/inference.py` to run different evaluation protocols:

- `test_iou`:  
  Used for **frame-level temporal action localization**, as reported in **Table 7 and Table 8** of the main paper.

- `test_oracle2`:  
  Used to evaluate the accuracy of $a_s$ under different numbers of **present labels** and **ground-truth video lengths**, corresponding to **Table 5 and Table 6** in the paper.




