SHARED_ARGS="--features 32 64 64 512 --replay_buffer_capacity 100_000 --n_buffers_to_load 3 \
    --batch_size 32 --update_horizon 1 --gamma 0.99 --n_epochs 50 --n_fitting_steps 62_500 \
    --alpha_cql 0.1 --learning_rate 5e-5"

GAME="Asterix"
DATA_DIR="YOUR_PATH/offline-dataset/$GAME"
N_BELLMAN_ITERATIONS=9
LAYER_NORM=1  # 0 1
BATCH_NORM=0  # 0 1
ARCHITECTURE_TYPE="impala"  # cnn impala
TARGET_UPDATE_FREQ=2000

if [ $LAYER_NORM == 1 ]
then
    SHARED_ARGS="$SHARED_ARGS --layer_norm"
fi
if [ $BATCH_NORM == 1 ]
then
    SHARED_ARGS="$SHARED_ARGS --batch_norm"
fi

SHARED_ARGS="$SHARED_ARGS --target_update_frequency $TARGET_UPDATE_FREQ --architecture_type $ARCHITECTURE_TYPE --data_dir $DATA_DIR --tmux_name slimdqn"
SHARED_NAME="LN${LAYER_NORM}_BN${BATCH_NORM}_${ARCHITECTURE_TYPE}_T${TARGET_UPDATE_FREQ}"
ISCQL_ARGS="--experiment_name L2_K${N_BELLMAN_ITERATIONS}_${SHARED_NAME}_D${TARGET_SYNC_FREQ}_${GAME} \
    --n_bellman_iterations $N_BELLMAN_ITERATIONS"

launch_job/atari/${PLATFORM}_iscql.sh --first_seed 1 --last_seed 1 --n_parallel_seeds 1 $SHARED_ARGS $ISCQL_ARGS
