# Implementation of iterated Shared Implicit Language Q Learning (iS-ILQL)

## User installation

### **Preprocessed Data and Reward Model**
 
Download `data.zip` from the Google drive folder [here](https://drive.google.com/drive/folders/1ltO6e4sP3waGPJoGFGuiHt7mJt8_2eP3?usp=sharing). Place the downloaded and unzipped folder, `data/` at the root of the repo. `data/` contains the preprocessed data for the Wordle game.

### **Dependencies and PYTHONPATH**

Please use Python 3.9.7. In the folder where the code is, create a Python virtual environment, activate it, and install the package and its dependencies, and update the PYTHONPATH as follows:
```bash
python3.9 -m venv env
source env/bin/activate
pip install -r requirements.txt
export PYTHONPATH="$PWD/src/"
```

## Running experiments
To train an iS-ILQL agent with configuration defined in `config/wordle/train_is_ilql.yaml` (default K=9), run:
```
cd scripts/train/wordle
python train_is_ilql.py
```