# CorrAttack: Black-box Adversarial Attack with Structured Search
This repository contains the code for reproducing the experimental results of attacking Imagenet dataset, of our submission: *CorrAttack: Black-box Adversarial Attack with Structured Search*.


## Requirements

Python packages: numpy, pytorch, torchvision, gpytorch.

You may install the package with 

```
pip install -r requirements.txt
```

Please download the weights and data from from https://drive.google.com/file/d/12xBDj0DWGgaralDNoMqe95_NTRpgFjpB/view?usp=sharing and extract it in the root folder;

## Reproducing the results

The result for CorrAttack$_\text{Flip}$  can be reproduced with   

```
python CorrAttack_Flip.py --device cuda:0 --config config/config_corrattack_flip.yaml --model_name [VGG16|Resnet50|Densenet121|] [--target] --epsilon [0.04|0.05|0.06]
```
where --target flag is to choose targeted attack

and the result for attacking defended model for CorrAttack$_\text{Flip}$  can be reproduced with 

```
python CorrAttack_Flip.py --device cuda:0 --config config/config_corrattack_flip_defense.yaml
```

For CorrAttack$_\text{Diff}$, the result could also be reproduced with the following command 

```
python CorrAttack_Diff.py --device cuda:0 --config config/config_corrattack_diff.yaml --model_name [VGG16|Resnet50|Densenet121|] [--target] --epsilon [0.04|0.05|0.06]
python CorrAttack_Diff.py --device cuda:0 --config config/config_corrattack_diff_defense.yaml
```