## Usage

To evaluate the hand-coded Transformer (Section 4), use:

```
python handcoding_experiment.py \
--n_bits=8 \
--verbose=False \
--fn="xor"
```

where `fn` is either "xor" or "sum" (of course, new programs can be defined as well).

To run training experiments (Section 5), use:

```
python training_experiment.py \
--res_pth=None \
--n_bits=8 \
--n_emb=128 \
--n_train=1000 \
--n_updates=4000 \
--strong_sprv=True \
--wpos_mode=0 \
--n_trials=1
```

where `res_pth` can be provided to specify a path to a file in which to save the results, and `wpos_mode` controls the initialization of the positional encoding matrix, with `wpos_mode=0` indicating learnable encodings, `wpos_mode=1` indicating fixed hand-coded initialization, and `wpos_mode=2` indicating sinusoidal initialization (from the original Transformer).

To run FPT experiments (Section 6), use:

```
python fpt_experiment.py \
--res_pth=None \
--n_bits=8 \
--task="sum" \
--n_train=10000 \
--n_test=10000 \
--n_trials=1
```

where `res_pth` can be provided to specify a path to a file in which to save the results, and `task` is either "sum" or "carries_sum".

