# Installation

* Setup conda environment (recommended).
```bash
# Create a conda environment
conda create -y -n adu python=3.10

# Activate the environment
conda activate adu

# Install torch (requires version >= 1.8.1) and torchvision
# Please refer to https://pytorch.org/ if you need a different cuda version
pip install torch==2.5.0 torchvision==0.20.0 torchaudio==2.5.0 --index-url https://download.pytorch.org/whl/cu124
```

* Install dassl library.
```bash
# Instructions borrowed from https://github.com/KaiyangZhou/Dassl.pytorch#installation

# Clone this repo
git clone https://github.com/KaiyangZhou/Dassl.pytorch.git
cd Dassl.pytorch/

# Install dependencies
pip install -r requirements.txt

# Install this library (no need to re-build if the source code is modified)
python setup.py develop
cd ..
```

* Clone Domain-Forgetting code repository and install requirements
```bash
# Install requirements
pip install -r requirements.txt
```

# Implementation

To run our method, execute the following command in the terminal:
```
bash main.sh <GPU_ID>
```