#!/bin/bash

# ==== User-defined Arguments ====
CUDA_DEVICE=$1  # e.g., 0

# ==== Experiment Configuration ====
DATASET="office_home_df"
SEED=1
CFG="vit_b16_ep50"
NCTX=4
DEPTH_VISION=9
DEPTH_TEXT=9
SHOTS=8
EXPNAME="BBF"
DATASETSEED=0
TRAINER="IVLP_VL_Adapter_Prompt"

USE_VISION_ADAPTER=False
USE_TEXT_ADAPTER=False

# ==== Loss and Feature Settings ====
USE_DOMAIN_CLS_LOSS=true
USE_NEAREST_NEIGHBOR_LOSS=false
IS_DOMAIN_DIVIDED=true
USE_CROSSATTENTION=true
DOMAIN_WEIGHT=30.0
MMD=10.0

# ==== Derived Flags ====
IS_DOMAIN_DIVIDED_FLAG=""
USE_DOMAIN_CLS_LOSS_FLAG=""
USE_NEAREST_NEIGHBOR_LOSS_FLAG=""
USE_CROSSATTENTION_FLAG="False"

[ "$IS_DOMAIN_DIVIDED" = true ] && IS_DOMAIN_DIVIDED_FLAG="--is_domain_divided"
[ "$USE_DOMAIN_CLS_LOSS" = true ] && USE_DOMAIN_CLS_LOSS_FLAG="--use_domain_cls_loss"
[ "$USE_NEAREST_NEIGHBOR_LOSS" = true ] && USE_NEAREST_NEIGHBOR_LOSS_FLAG="--use_nearest_neighbor_loss"
[ "$USE_CROSSATTENTION" = true ] && USE_CROSSATTENTION_FLAG="True"

# ==== Run ====
SUBEXPNAME="MMD"
DIR="outputs"

echo "Running training and saving output to ${DIR}"

CUDA_VISIBLE_DEVICES=${CUDA_DEVICE} python train_loop.py \
    --root / \
    --seed ${SEED} \
    --trainer ${TRAINER} \
    --dataset-config-file configs/datasets/${DATASET}.yaml \
    --config-file configs/trainers/IVLP/${CFG}.yaml \
    --output-dir ${DIR} \
    --num_shots ${SHOTS} \
    --dataset_name ${DATASET} \
    --dataset_seed ${DATASETSEED} \
    --experiment_name ${EXPNAME} \
    --sub_experiment_name ${SUBEXPNAME} \
    --mmd_weight ${MMD} \
    --domainloss_weight ${DOMAIN_WEIGHT} \
    ${IS_DOMAIN_DIVIDED_FLAG} \
    ${USE_DOMAIN_CLS_LOSS_FLAG} \
    ${USE_NEAREST_NEIGHBOR_LOSS_FLAG} \
    TRAINER.IVLP.PROMPT_DEPTH_VISION ${DEPTH_VISION} \
    TRAINER.IVLP.N_CTX_VISION ${NCTX} \
    TRAINER.IVLP.PROMPT_DEPTH_TEXT ${DEPTH_TEXT} \
    TRAINER.IVLP.N_CTX_TEXT ${NCTX} \
    USE_CROSSATTENTION ${USE_CROSSATTENTION_FLAG} \
    INSERT_LAYER_ATTN ${DEPTH_VISION} \
    USE_TEXT_ADAPTER ${USE_TEXT_ADAPTER} \
    USE_VISION_ADAPTER ${USE_VISION_ADAPTER}
