#!/bin/bash

# Main Experiments
for example in "satellite" "dragons" "earth" "meltingman" "birds" "glass"
do
   python clip_maker_latent.py --tag final_v012 --example $example
done


# Ablaion Study
for example in "dragons" "earth" "satellite" "glass"
do
   python clip_maker_latent.py --tag final_nospatialeta --no-spatialeta --example $example
   python clip_maker_latent.py --tag final_addentstozero --crossframeattention_pattern "[[0],[0]]" --example $example
   python clip_maker_latent.py --tag final_addentstoprev --crossframeattention_pattern "[[0,0],[1,1],[1,1]]" --example $example
   python clip_maker_latent.py --tag final_addentstonone --crossframeattention_pattern "[[0],[1]]" --example $example
   python clip_maker_latent.py --tag final_noinversion --no-invert --example $example
   python clip_maker_latent.py --tau 100 --tag final_tau100 --example $example
   python clip_maker_latent.py --tau 900 --tag final_tau900 --example $example
done
