import numpy as np
import matplotlib.pyplot as plt

# Example data
x = [512, 1024, 2048, 4096]
y_baseline = [0.368, 0.82, 2.19, 6.09599999999999]  # Baseline values
y1 = [0.362, 0.784, 2.04, 5.578]
y2 = [0.35, 0.742, 1.886, 5.05]
y3 = [0.34, 0.716, 1.77, 4.664]
y4 = [0.322, 0.66, 1.582, 4.01]

# Normalize each line by the baseline values
y1_norm = [b/y for y, b in zip(y1, y_baseline)]
y2_norm = [b/y for y, b in zip(y2, y_baseline)]
y3_norm = [b/y for y, b in zip(y3, y_baseline)]
y4_norm = [b/y for y, b in zip(y4, y_baseline)]

# Set figure size
plt.figure(figsize=(8, 4))

# Plotting normalized lines
plt.plot(x, [1] * len(x), label='Baseline (Norm.)', color='black', marker='*', markersize=8, linewidth=2.5)  # Baseline is always 1
plt.plot(x, y1_norm, label='Attn NBL-4', color='#1f77b4', marker='o', markersize=6, linewidth=2.5)  # Dark Blue - Circle
plt.plot(x, y2_norm, label='Attn NBL-8', color='#4878cf', marker='s', markersize=6, linewidth=2.5)  # Medium Blue - Square
plt.plot(x, y3_norm, label='Attn NBL-12', color='#6baed6', marker='o', markersize=6, linewidth=2.5)  # Light Blue - Circle
plt.plot(x, y4_norm, label='Attn NBL-16', color='#9ecae1', marker='s', markersize=6, linewidth=2.5)  # Lighter Blue - Square
plt.ylim(0.95, 1.65)
# Add labels and title
plt.xlabel('Context Length', fontsize=16, fontweight='bold')
plt.ylabel('Prefill Speed-up', fontsize=16, fontweight='bold')

# Add gridlines
plt.grid(which='both', linestyle='--', linewidth=0.7, alpha=0.6)

# Improve legend placement and style
plt.legend(fontsize=12, loc='upper left', shadow=True, frameon=True, fancybox=True)

# Save plot to file
plt.savefig('normalized_plot.png', dpi=300, bbox_inches='tight')

# Clear the figure after saving
plt.close()
