import torch
from torch.utils.tensorboard import SummaryWriter
import torch.backends.cudnn as cudnn
import argparse

parser = argparse.ArgumentParser()
parser.add_argument('--qphase', help='train/calib/validation', type=int, default=2)

parser.add_argument('--qnw', help='data bit-with', type=int, default=8)
parser.add_argument('--qna', help='data bit-with', type=int, default=16)
parser.add_argument('--qnq', help='data bit-with', type=int, default=16)
parser.add_argument('--qnk', help='data bit-with', type=int, default=8)
parser.add_argument('--qnv', help='data bit-with', type=int, default=8)

parser.add_argument('--qm', help='quantization mode', type=int, default=3)
parser.add_argument('--qe', help='exponent', type=int, default=3)
parser.add_argument('--qnosub', help='no subnormal in Floating-Point', action='store_true')

parser.add_argument('--kvquant', help='kv quant mode', type=int, default=2)

parser.add_argument('--QRw', help='QR weight bit-width', type=int, default=4)
parser.add_argument('--QRa', help='QR activation bit-width', type=int, default=4)
parser.add_argument('--QRq', help='QR query bit-width', type=int, default=4)
parser.add_argument('--QRk', help='QR key bit-width', type=int, default=4)
parser.add_argument('--QRv', help='QR value bit-width', type=int, default=4)
parser.add_argument('--QRg', help='QR group coding', type=int, default=16)

opt, _ = parser.parse_known_args()


class QInfo():
    def __init__(self, phase, data, qm=6, n=8, e=2, QRn=0, QRg=0, nosub=False):
        self.phase = phase
        self.data = data
        self.n = n

        self.qm = qm
        self.e = e
        self.nosub = nosub
        self.QRn = QRn
        self.QRg = QRg
