import scipy.spatial

import torch

def heuristics_v2(distance_matrix: torch.Tensor) -> torch.Tensor:
    """
    heu_ij = - sigmoid(dis_ij) if j is the nearest neighbor of i, else 0
    """
    distance_matrix[distance_matrix == 0] = 1e5
    # Find the nearest neighbors
    nearest_neighbors = torch.argmin(distance_matrix, dim=1)
    heu = torch.zeros_like(distance_matrix)
    # Apply -sigmoid(d_ij) only to the nearest neighbor elements
    heu[torch.arange(len(heu)), nearest_neighbors] = -torch.sigmoid(distance_matrix[torch.arange(len(heu)), nearest_neighbors])
    return heu
