import torch
import torch.nn.functional as F

def heuristics(decoder, encoded_last_node, ninf_mask):
    head_num = decoder.model_params['head_num']
    
    q_last = decoder.Wq_last(encoded_last_node).view(encoded_last_node.size(0), head_num, -1)
    q = decoder.q_first + q_last
    out_concat = decoder.multi_head_attention(q, decoder.k, decoder.v, rank3_ninf_mask=ninf_mask)
    mh_atten_out = decoder.multi_head_combine(out_concat)
    
    score = torch.matmul(mh_atten_out, decoder.single_head_key)
    
    problem_size = ninf_mask.size(-1)
    scale_factor = torch.log(torch.tensor(problem_size, dtype=torch.float, device=score.device))
    randomness = torch.randn_like(score) * 0.1
    dynamic_bias = torch.relu(torch.matmul(encoded_last_node, decoder.single_head_key)) * scale_factor + randomness
    score = score + dynamic_bias
    
    sqrt_embedding_dim = decoder.model_params['sqrt_embedding_dim']
    logit_clipping = decoder.model_params['logit_clipping']
    score_scaled = score / sqrt_embedding_dim
    score_clipped = logit_clipping * torch.tanh(score_scaled)
    score_masked = score_clipped + ninf_mask
    probs = F.softmax(score_masked, dim=2)
    
    return probs
