import logging
from typing import Optional
from .base import BaseClient
from openai import OpenAI

# 初始化日志记录器
logger = logging.getLogger(__name__)
logger.setLevel(logging.DEBUG)  # 设置日志级别为DEBUG，记录所有日志
handler = logging.StreamHandler()  # 控制台输出
formatter = logging.Formatter('%(asctime)s - %(levelname)s - %(message)s')
handler.setFormatter(formatter)
logger.addHandler(handler)

class AgictoClient(BaseClient):
    ClientClass = OpenAI

    def __init__(
        self,
        model: str,
        temperature: float = 1.0,
        base_url: Optional[str] = None,
        api_key: Optional[str] = None,
    ) -> None:
        super().__init__(model, temperature)

        if isinstance(self.ClientClass, str):
            logger.fatal(f"Package `{self.ClientClass}` is required")
            exit(-1)

        # 初始化 agicto 客户端实例，传入 api_key 与 base_url 等参数
        self.client = self.ClientClass(api_key="sk-OKqg8sHiPMBipZAenbby7V71C2AfaKFugg5b9sm8bIlYspgj", base_url="https://api.agicto.cn/v1")
        logger.info("AgictoClient initialized successfully.")

    def _chat_completion_api(self, messages: list[dict], temperature: float, n: int = 1):
        """
        这个函数调用agicto的API生成基于提供的消息的n个聊天回应。
        它使用agicto的ChatCompletion API，并处理可能的错误。
        """

        try:
            # 确保消息内容是UTF-8编码
            for message in messages:
                message['content'] = message['content'].encode('utf-8').decode('utf-8')    

            # 调用agicto的ChatCompletion API来生成聊天回应
            response = self.client.chat.completions.create(
                messages=messages,  # 传入消息列表
                model="gpt-3.5-turbo",  # 使用的模型，假设是gpt-4o-mini
            )

            # 获取返回的回应内容
            response_choices = response.choices

            # 如果返回的choices为空，记录日志并返回None
            if not response_choices:
                logger.warning("返回的回应为空")
                return None

            # 记录API成功响应
            return response_choices

        except Exception as e:
            # 捕获异常并记录错误日志
            logger.error(f"调用agicto API时发生错误：{e}", exc_info=True)
            return None
