import time
from typing import Optional
import time
import logging
import concurrent
from random import random
from openai import OpenAI

# 初始化日志记录器
logger = logging.getLogger(__name__)
logger.setLevel(logging.DEBUG)  # 设置日志级别为DEBUG
handler = logging.StreamHandler()  # 控制台输出
formatter = logging.Formatter('%(asctime)s - %(levelname)s - %(message)s')
handler.setFormatter(formatter)
logger.addHandler(handler)

class BaseClient(object):
    def __init__(
        self,
        model: str,
        temperature: float = 1.0,
    ) -> None:
        self.model = model
        self.temperature = temperature
    # def _chat_completion_api(self, messages: list[dict], temperature: float, n: int = 1):
    #     raise NotImplemented

    def _chat_completion_api(self, messages: list[dict], temperature: float, n: int=1):
        """
        这个函数调用agicto的API生成基于提供的消息的n个聊天回应。
        它使用agicto的ChatCompletion API，并处理可能的错误。
        """
        try:
            for message in messages:
                message['content'] = message['content'].encode('utf-8').decode('utf-8')      
            # 创建 OpenAI 客户端实例，使用agicto提供的API key和base_url
            client = OpenAI(
                api_key="sk-OKqg8sHiPMBipZAenbby7V71C2AfaKFugg5b9sm8bIlYspgj",  # 填入你的API密钥
                base_url="https://api.agicto.cn/v1"  # agicto的API base URL
            )
            
            # 调用agicto的ChatCompletion API来生成聊天回应
            response = client.chat.completions.create(
                messages=messages,  # 传入消息列表
                model="gpt-3.5-turbo",  
            )
            
            # 获取返回的回应内容
            response_choices = response.choices
            
            # 如果返回的choices为空，返回None
            if not response_choices:
                print("None")
                return None
            
            # 提取回应内容并返回
            return response_choices
        
        except Exception as e:
            # 捕获和处理所有可能的异常
            print(f"调用agicto API时发生错误：{e}", flush=True)
            return None


    def chat_completion(self, n: int, messages: list[dict], temperature: Optional[float] = None) -> list[dict]:
        """
        Generate n responses using OpenAI Chat Completions API
        """
        temperature = temperature or self.temperature
        time.sleep(random())
        for attempt in range(1000):
            try:
                response_cur = self._chat_completion_api(messages, temperature, n)
                # 如果成功调用并且返回值非空，则跳出循环
                if response_cur is not None:
                    break
            except Exception as e:
                print(f"调用 _chat_completion_api 失败，错误为：{e}", flush=True)
                # 可选：在这里打印 traceback 以便了解错误详细信息
                import traceback
                traceback.print_exc()
                time.sleep(1)
        if response_cur is None:
            print("代码终止：经过多次尝试依然没有得到有效结果", flush=True)
            exit()
            
        return response_cur

    
    def multi_chat_completion(self, messages_list: list[list[dict]], n: int = 1, temperature: Optional[float] = None):
        """
        An example of messages_list:
        
        messages_list = [
            [
                {"role": "system", "content": "You are a helpful assistant."},
                {"role": "user", "content": "Hello!"},
            ],
            [
                {"role": "system", "content": "You are a knowledgeable guide."},
                {"role": "user", "content": "How are you?"},
            ],
            [
                {"role": "system", "content": "You are a witty comedian."},
                {"role": "user", "content": "Tell me a joke."},
            ]
        ]
        param: n: number of responses to generate for each message in messages_list
        """
        # If messages_list is not a list of list (i.e., only one conversation), convert it to a list of list
        assert isinstance(messages_list, list), "messages_list should be a list."
        if not isinstance(messages_list[0], list):
            messages_list = [messages_list]
        
        if len(messages_list) > 1:
            assert n == 1, "Currently, only n=1 is supported for multi-chat completion."
        # 如果模型不是 gpt 模型，对 messages_list 做扩展
        if "gpt" not in self.model:
            messages_list *= n
            n = 1
        results = []
        # 使用 ThreadPoolExecutor 并提交任务以便更好捕获异常和日志
        import concurrent.futures
        with concurrent.futures.ThreadPoolExecutor() as executor:
            future_to_messages = {}
            for messages in messages_list:
                params = dict(n=n, messages=messages, temperature=temperature)
                future = executor.submit(self.chat_completion, **params)
                future_to_messages[future] = messages
                # print(f"messages: {messages}")
            for future in concurrent.futures.as_completed(future_to_messages):
                try:
                    choice = future.result()
                except Exception as exc:
                    logger.error(f"chat_completion generated an exception for messages: {messages}\nException: {exc}")
                    choice = []
                results.append(choice)

        # 处理结果，将所有返回的 message 内容汇总到一个列表中
        contents: list[str] = []
        for choice in results:
            # 如果 choice 为空，记录日志并跳过
            if not choice:
                logger.warning("Received empty response for one of the chat_completion calls.")
                continue
            for c in choice:
                try:
                    content = c.message.content
                    contents.append(content)
                except Exception as e:
                    logger.error(f"Error extracting content from response: {c}. Exception: {e}")
        return contents
