# api_client/openai_client.py

import requests
import json
from config import OPENAI_API_KEY, OPENAI_API_URL


def ask_for_openai(content: str, pre_prompt: str = "", post_prompt: str = "", model: str = "gpt-3.5-turbo",
                   temperature: float = 0.2) -> str:
    """
    调用 OpenAI API，生成模型的回复。

    Args:
        content (str): 用户提供的内容
        pre_prompt (str): 在内容之前的提示语
        post_prompt (str): 在内容之后的提示语
        model (str): 使用的模型名称
        temperature (float): 控制输出的随机性

    Returns:
        str: 模型生成的回复
    """

    # 定义请求头
    headers = {
        'Content-Type': 'application/json',
        'Authorization': f'Bearer {OPENAI_API_KEY}'
    }

    # 定义请求数据
    data = {
        "model": model,
        "messages": [
            {"role": "user", "content": pre_prompt + "\n\n" + content + "\n\n" + post_prompt}
        ],
        "temperature": 0.2
    }

    return "test"

    # 发送 POST 请求
    response = requests.post(OPENAI_API_URL, headers=headers, data=json.dumps(data))

    # 解析响应
    if response.status_code == 200:
        result = response.json()['choices'][0]['message']['content']
        return result
    else:
        print(f"Request failed with status code {response.status_code}")
        return None
