EXTRACT_THEME = '''Please extract the key issue addressed, the proposed method, and the application domain from the abstract of the paper titled *{title}* and present the information in the following JSON format.
{{
    "problem": {{
        "name": the key issue it addressed,
        "description": a more detailed description of this key issue
    }}
    "method": {{
        "name": the method it proposed,
        "description": a more detailed description of this method
    }}
    "domain": {{
        "name": the application domain,
        "description": a more detailed description of this domain
    }}
}}]
If any of the information is not available, please fill the corresponding value with 'null'. Note that the descriptions should be extracted from context, DO NOT simply use your prior knowledge to complete them.
Absract Content: {abstract}'''

PARSE_IEEE_REF_SYS = '''Extract the artile title and the pulication date/year from the reference entry provided by the user, and return it in JSON format.
Here is an example for you:
Reference Entry: Z. Zhong, Z. Liu, M. Tegmark, and J. Andreas. The clock and the pizza: Two stories in mechanistic explanation of neural networks. In Thirty-seventh Conference on Neural Information Processing Systems, 2023.
Parse Result: 
    {
        "title": "The clock and the pizza: Two stories in mechanistic explanation of neural networks",
        "timestamp": "2023"
    }'''
PARSE_APA_REF_SYS = '''Extract the first author of the list of authors, article title, and date from the reference entry provided by the user, and return it in JSON format.
Requirements:
1. Please note that only the year and any immediately following letters (if present) should be retained from the extracted time. 
2. If there are ONLY two authors, extract the last names of them as the example shows:
    reference entry: Ilya Loshchilov and Frank Hutter. 2017. Decoupled weight decay regularization. arXiv preprint arXiv:1711.05101.
    parse result:
    [{"author": "Loshchilov and Hutter", "title": "Decoupled weight decay regularization", "date": "2015"}]
    Do not use '&', just use and.
3. If this entry includes more than one reference, your reply should be a list containing all the dict results. If you believe the content is not a reference, reply with an empty list.
Here is an example:
reference entry: Jason Wei, Xuezhi Wang, Dale Schuurmans, Maarten Bosma, Brian Ichter, Fei Xia, Ed Chi, Quoc Le, and Denny Zhou. Chain of thought prompting elicits reasoning in large language models. Conference on Neural Information Processing Systems (NeurIPS), 2022a. URL https://arxiv. org/pdf/2201.11903.
parse result:
    [{
        "author": "Jason Wei",
        "title": "Chain of thought prompting elicits reasoning in large language models",
        "date": "2022a"
    }]'''
PARSE_REF_USER = '''Reference Entry: {ref}'''

EXTRACT_APA_REF = '''Extract the references from the following text.
Requirements:
    1. The citations within the same parentheses should be placed in the same list.
    2. If there is no reference mentioned in the text, reply with an empty list.
    3. You should pay special attention to the citation like 'Tang et al., 2023b,a', which should be parsed into two entries: {"authors": "Tang et al.", "year": "2023b"}, {"authors": "Tang et al.", "year": "2023a"}
    4. Please do not merge extractions that are not enclosed in a single set of parentheses.
    5. Return the extraction results in the following JSON format.
        [
            {
                "raw reference": ...,
                "parsed result": [
                    {"authors": ..., "year": ...},
                    ...
                ],
            },
            ...
        ]
Example:
    user input: Some recent methods (Jin et al., 2020a; Li et al., 2021, 2022) combine graph neural networks (GNNs) and recurrent neural networks (RNNs) to model the semantic and temporal dependencies between entities. Liang et al. (2023) proposed a multi-agent debate framework in which various agents put forward their statements in a tit for tat pattern. medical evidence summarization (Tang et al., 2023b,a; Shaib et al., 2023), concerns persist when LLMs encounter clinical inquiries
    result: 
        [
            {
                "raw reference": "(Jin et al., 2020a; Li et al., 2021, 2022)",
                "parsed result": [
                    {"authors": "Jin et al.", "year": "2020a"},
                    {"authors": "Li et al.", "year": "2021"},
                    {"authors": "Li et al.", "year": "2022"},
                ]
            },
            {
                "raw reference": "Liang et al. (2023)",
                "parsed result": [
                    {"authors": "Liang et al.", "year": "2023"}
                ]
            },
            {
                "raw reference": "(Tang et al., 2023b,a; Shaib et al., 2023)",
                "parsed result": [
                    {"authors": "Tang et al.", "year": "2023b"},
                    {"authors": "Tang et al.", "year": "2023a"},
                    {"authors": "Shaib et al.", "year": "2023"}
                ]
            }
        ]
Text Content: '''

LEVEL1 = '''Please extract the method and problem entities related to the citation '{citations}' from the excerpt of the paper titled '{title}', and identify the relations between these entities and the citation. Please respond with the following JSON format.
        [
            {{
                "entity name": The name of the entity that has relation with the citation '{citations}'. DO NOT extract human names as entities,
                "entity type': The type of the entity, selected from 'method', 'problem', and 'domain',
                "description": Description of the entity extracted from the context, null if not enough information,
                "relation": The relationship between the citation and the entity extracted from the context can be expressed using phrases such as 'applied in', 'proposed by', and others. Ensure that the relation is explicitly mentioned in the text and avoid inferring any relations based on prior knowledge. Do not use vague description like 'related to'
            }},
            ...
        ]
    '''
LEVEL2 = '''Find out the relationships between these entities in the content. DO NOT add relations including entities that do not exist in the list. Please respond with the following format.
    [{{
        "entity1": The name of the entity1,
        "relation": The relationship between entity1 and entity2. Ensure that the relation is explicitly mentioned in the text and avoid inferring any relations based on prior knowledge. Do not use vague description like 'related to',
        "entity2": The name of the entity2
    }},
    ...]
    Entities: {entities}
    Content: {content}'''
    
FIND_SIMILAR_ENTITY = '''There is a list of names for three types of entities extracted from the content: problem and method. You need to identify the entities in this list that refer to the same entity but have different names based on the context. Return the results in the following JSON format.
    [
        {{
            "reason": evidence for why these elements are identified referring to the same entity,
            "new name": Select the most one from duplicate names. DO NOT create a new name,
            "duplicates": the list of duplicate names
        }},
        ...
    ]
    For example, "LLMs", "Large Language Models (LLMs)", and "Large Language Models" can be updated to {{"new name": "Large Language Models (LLMs)", "duplicates": ["LLMs", "Large Language Models (LLMs)", and "Large Language Models"]}}. Return an empty list if you believe there is no such elements.
    ATTENTION: Names that are considered to refer to the same entity will be merged. To avoid incomplete entity extraction, your choices should be more conservative and cautious.
    Text Content: {content}
    Name List: {names}'''
    
CLEAR_LAST_REF_ENTRY = '''This text should be a reference entry, but it likely contains content from other sections or is not a reference entry at all. If it is actually a reference entry containing one or more references, please return 'True'; if it contains other content (usually at the end), please extract the reference entry and REPLY ONLY WITH IT; if it is completely not a reference entry, please return 'False'. A reference entry should be like this:
        [6] Ben Athiwaratkun, Sujan Kumar Gonugondla, Sanjay Krishna Gouda, Haifeng Qian, Hantian Ding, Qing Sun, Jun Wang, Jiacheng Guo, Liangfu Chen, Parminder Bhatia, Ramesh Nallapati, Sudipta Sengupta, and Bing Xiang. Bifurcated attention: Accelerating massively parallel decoding with shared prefixes in llms, 2024. URL https://arxiv.org/abs/2403.08845.
or this:
        Ethan Brooks, Logan A Walls, Richard Lewis, and Satinder Singh. 2023. Large language models can implement policy iteration. In Thirty-seventh Conference on Neural Information Processing Systems.
Text:
'''
CLEAR_RELATED_WORK = '''This excerpt of related work text extracted from the PDF may contain information from figures; please remove any content that is unrelated to the related work. If there are numbers in the brackets, then it is in IEEE citation format. If there are author names and year in the brackets or parentheses, then it is in APA citation format. If it is in IEEE citation format, please ensure that there are only numbers and English commas within the brackets. If it is in APA citation format, please JUST remove the unrelated content and DO NOT change its citation. Only reply with the content cleaned.
'''
FILTER_IRRELEVANT = '''Based on the abstract and title, Do you think this article is relevant to the topic? Reply with 'yes' or 'no'.
Title: {title}
Abstract: {abstract}'''