PARSE_REF_SYS = '''Extract the first author of the list of authors, article title, and date from the reference entry provided by the user, and return it in JSON format.
Please note that only the year and any immediately following letters (if present) should be retained from the extracted time.
Here is an example:
reference entry: Jason Wei, Xuezhi Wang, Dale Schuurmans, Maarten Bosma, Brian Ichter, Fei Xia, Ed Chi, Quoc Le, and Denny Zhou. Chain of thought prompting elicits reasoning in large language models. Conference on Neural Information Processing Systems (NeurIPS), 2022a. URL https://arxiv. org/pdf/2201.11903.
parse result:
    {
        "author": "Jason Wei",
        "title": "Chain of thought prompting elicits reasoning in large language models",
        "date": "2022a"
    }''' 
PARSE_REF_USER = '''reference entry: {ref}'''

EXTRACT_REF_SYS = '''You are a reference extraction assistant, tasked with extracting the references mentioned in the text provided by the user and return the extraction results in the specified format. 
If there is no reference mentioned in the text, reply with an empty list as shown in example4.
Here are a few examples:
Example1:
    user input: Some recent methods (Jin et al., 2020a; Li et al., 2021, 2022) combine graph neural networks (GNNs) and recurrent neural networks (RNNs) to model the semantic and temporal dependencies between entities.
    result: 
        [
            {"authors": "Jin et al.", "year": "2020a"},
            {"authors": "Li et al.", "year": "2021"},
            {"authors": "Li et al.", "year": "2022"},
        ]
Example2:
    user input: Recently, MetaTKG (Xia et al., 2022) proposes a temporal meta-learner to learn evolution patterns of facts.
    result:
        [
            {"authors": "Xia et al.", "year": "2022"}
        ]
Example3:
    user input: Liang et al. (2023) proposed a multi-agent debate framework in which various agents put forward their statements in a tit for tat pattern.
    result:
        [
            {"authors": "Liang et al.", "year": "2023"}
        ]
Example4:
    user input: ## 2.1 TKG Reasoning under the Extrapolation Setting
    result:
        []
Example5:
    user input: medical evidence summarization (Tang et al., 2023b,a; Shaib et al., 2023), concerns persist when LLMs encounter clinical inquiries
    result:
        [
            {"authors": "Tang et al.", "year": "2023b"},
            {"authors": "Tang et al.", "year": "2023a"},
            {"authors": "Shaib et al.", "year": "2023"}
        ]
    You should pay special attention to the citation like 'Tang et al., 2023b,a', which should be parsed into two entries: {"authors": "Tang et al.", "year": "2023b"}, {"authors": "Tang et al.", "year": "2023a"}
'''
EXTRACT_REF_USER = '''Extract all the references in the following text:
{content}'''

"""
entity type definition: 
    - paper
        the paper mentioned in the content
    - method
        a systematic way of doing something, often involving a specific procedure or technique
    - problem
        the problems mentioned in the article or to be addressed
    - domain
        the domain mentioned in the article, usually related to the problems or methods
        
entity node structure:
    {
        "entity name": name,
        "entity type": type,
        "timestamp": occuring time of the entity mentioned in the content,
        "description": abstract or description of the entity in the paper (if it is not a paper entity and there is no further description in the text, then it is null).
    }
    
relation:
    {
        "entity1": entity1,
        "relation": description of the relation between Entity1 and Entity2 extracted from the text, without directionality.
        "entity2": entity2
    }
"""
EXTRACT_ABSTRACT_ENTITY = '''TASK: The text provided to you including the paper title and the abstract excerpt of the paper. Please extract CORE entities from the text, with entity types ONLY selected from method, problem, domain, and paper, which serve as keywords of logical framework.
REQUIREMENTS: 
1. Your attention should be focused on the problems, corresponding methods to address them, existing domains, and other related content.
2. The paper entity can ONLY be the paper itself.
3. Please extract from a logical framework perspective, omitting implementation details. 
4. format requirement:
    the entity node structure: 
        {
            "entity name": name,
            "entity type": type,
            "timestamp": occuring time of the entity mentioned in the content (null if not mentioned),
            "description": abstract or description of the entity in the paper (if it is not a paper entity and there is no further description in the text, then it is null).
        }
    the final result should be a list consisting of all the entities. Please return a valid JSON object without adding any extra tags or explanations.
EXAMPLE:
    TEXT:
        - paper title: Planning-oriented Autonomous Driving
        - abstract: Modern autonomous driving system is characterized as modular tasks in sequential order, i.e., perception, prediction, and planning. In order to perform a wide diversity of tasks and achieve advanced-level intelligence, contemporary approaches either deploy standalone models for individual tasks, or design a multi-task paradigm with separate heads. However, they might suffer from accumulative errors or deficient task coordination. Instead, we argue that a favorable framework should be devised and optimized in pursuit of the ultimate goal, i.e., planning of the self-driving car. Oriented at this, we revisit the key components within perception and prediction, and prioritize the tasks such that all these tasks contribute to planning. We introduce Unified Autonomous Driving (UniAD), a comprehensive framework up-to-date that incorporates full-stack driving tasks in one network. It is exquisitely devised to leverage advantages of each module, and provide complementary feature abstractions for agent interaction from a global perspective. Tasks are communicated with unified query interfaces to facilitate each other toward planning. We instantiate UniAD on the challenging nuScenes benchmark. With extensive ablations, the effectiveness of using such a philosophy is proven by substantially outperforming previous state-of-the-arts in all aspects. Code and models are public.
    RESULT:
        [
            {
                "entity name": "Planning-oriented Autonomous Driving",
                "entity type": "paper",
                "timestamp": null,
                "description": "This paper addresses the design and optimization of autonomous driving systems focusing on planning as the ultimate goal, incorporating perception and prediction to enhance task coordination."
            },
            {
                "entity name": "autonomous driving",
                "entity type": "domain",
                "timestamp": null,
                "description": "a multidisciplinary domain that encompasses the development and implementation of technologies enabling vehicles to operate without human intervention."
            },
            {
                "entity name": "Standalone models for individual tasks",
                "entity type": "method",
                "timestamp": null,
                "description": "past method deployed for increasing task diversity and achieving advanced-level intelligence within autonomous driving systems."
            },
            {
                "entity name": "multi-task paradigm with separate heads",
                "entity type": "method",
                "timestamp": null,
                "description": "past method deployed for increasing task diversity and achieving advanced-level intelligence within autonomous driving systems."
            },
            {
                "entity name": "accumulative errors and deficient task coordination",
                "entity type": "problem",
                "timestamp": null,
                "description": "problems caused by past approaches in autonomous driving systems"
            },
            {
                "entity name": "Unified Autonomous Driving (UniAD)",
                "entity type": "method",
                "timestamp": null,
                "description": "A comprehensive framework, proposed by the paper Planning-oriented Autonomous Driving, incorporating full-stack driving tasks in one network to improve planning by leveraging each module's advantages and providing complementary feature abstractions."
            }
        ]'''
EXTRACT_ABSTRACT_RELATION = '''TASK: The text provided to you including the paper title and the abstract excerpt of the paper. Please extract the relations of the entities.
REQUIREMENTS:
1. Please ensure that both entities in the relation entry you extract have already appeared in the entity list.
2. Please extract from a logical framework perspective, omitting implementation details.
3. Make sure you look for the corresponding relationships for each entity.
4. format requirement:
        {
            "entity1": entity1,
            "relation": description of the relation between Entity1 and Entity2 extracted from the text, without directionality.
            "entity2": entity2
        }
    the final result should be a LIST including all the relations. Please return a valid JSON object without adding any extra tags or explanations.
EXAMPLE:
    TEXT:
        - paper title: Planning-oriented Autonomous Driving
        - abstract: Modern autonomous driving system is characterized as modular tasks in sequential order, i.e., perception, prediction, and planning. In order to perform a wide diversity of tasks and achieve advanced-level intelligence, contemporary approaches either deploy standalone models for individual tasks, or design a multi-task paradigm with separate heads. However, they might suffer from accumulative errors or deficient task coordination. Instead, we argue that a favorable framework should be devised and optimized in pursuit of the ultimate goal, i.e., planning of the self-driving car. Oriented at this, we revisit the key components within perception and prediction, and prioritize the tasks such that all these tasks contribute to planning. We introduce Unified Autonomous Driving (UniAD), a comprehensive framework up-to-date that incorporates full-stack driving tasks in one network. It is exquisitely devised to leverage advantages of each module, and provide complementary feature abstractions for agent interaction from a global perspective. Tasks are communicated with unified query interfaces to facilitate each other toward planning. We instantiate UniAD on the challenging nuScenes benchmark. With extensive ablations, the effectiveness of using such a philosophy is proven by substantially outperforming previous state-of-the-arts in all aspects. Code and models are public.
    ENTITIES:
        [
            {
                "entity name": "Planning-oriented Autonomous Driving",
                "entity type": "paper",
                "timestamp": null,
                "description": "This paper addresses the design and optimization of autonomous driving systems focusing on planning as the ultimate goal, incorporating perception and prediction to enhance task coordination."
            },
            {
                "entity name": "autonomous driving",
                "entity type": "domain",
                "timestamp": null,
                "description": "a multidisciplinary domain that encompasses the development and implementation of technologies enabling vehicles to operate without human intervention."
            },
            {
                "entity name": "Standalone models for individual tasks",
                "entity type": "method",
                "timestamp": null,
                "description": "past method deployed for increasing task diversity and achieving advanced-level intelligence within autonomous driving systems."
            },
            {
                "entity name": "multi-task paradigm with separate heads",
                "entity type": "method",
                "timestamp": null,
                "description": "past method deployed for increasing task diversity and achieving advanced-level intelligence within autonomous driving systems."
            },
            {
                "entity name": "accumulative errors and deficient task coordination",
                "entity type": "problem",
                "timestamp": null,
                "description": "problems caused by past approaches in autonomous driving systems"
            },
            {
                "entity name": "Unified Autonomous Driving (UniAD)",
                "entity type": "method",
                "timestamp": null,
                "description": "A comprehensive framework, proposed by the paper Planning-oriented Autonomous Driving, incorporating full-stack driving tasks in one network to improve planning by leveraging each module's advantages and providing complementary feature abstractions."
            }
        ]
    RESULT:
        [
            {
                "entity1": "Standalone models for individual tasks",
                "relation": "method used in",
                "entity2": "autonomous driving"
            },
            {
                "entity1": "multi-task paradigm with separate heads",
                "relation": "method used in",
                "entity2": "autonomous driving"
            },
            {
                "entity1": "Standalone models for individual tasks",
                "relation": "suffers from",
                "entity2": "accumulative errors and deficient task coordination"
            },
            {
                "entity1": "multi-task paradigm with separate heads",
                "relation": "suffers from",
                "entity2": "accumulative errors and deficient task coordination"
            },
            {
                "entity1": "Planning-oriented Autonomous Driving",
                "relation": "proposes",
                "entity2": "Unified Autonomous Driving (UniAD)"
            },
            {
                "entity1": "Unified Autonomous Driving (UniAD)",
                "relation": "is designed for",
                "entity2": "autonomous driving"
            },
            {
                "entity1": "Unified Autonomous Driving (UniAD)",
                "relation": "addresses",
                "entity2": "accumulative errors and deficient task coordination"
            }
        ]'''

EXTRACT_RELATED_WORK_ENTITY = '''TASK: 
The text provided to you is a paper excerpt and references it mentions. Please extract entities from the text based on the following questions: 1. Which papers are cited in this text? Considering their titles, why are these papers cited? 2. What fields, methods, and technologies are mentioned in this text? How are they related to each other? You can only choose entity type from method, problem, domain, and paper.
REQUIREMENTS: 
1. Your attention should be focused on the problems, corresponding methods to address them, existing domains, and other related content.
2. The paper entity can ONLY be the citation mentioned in the content, make sure you have extracted all the citation entities. The 'entity name' of these paper entity should be their titles.
3. format requirement:
    the entity node structure: 
        {
            "entity name": name,
            "entity type": type,
            "timestamp": occuring time of the entity mentioned in the content (null if not mentioned),
            "description": abstract or description of the entity in the paper (if it is not a paper entity and there is no further description in the text, then it is null).
        }
    the final result should be a list consisting of the entities. Please return a valid JSON object without adding any extra tags or explanations.
EXAMPLE:
    TEXT:
        - paper title: TextGrad: Advancing Robustness Evaluation in NLP by Gradient-Driven Optimization
        - excerpt theme: Adversarial attacks in NLP.
        - content: Different from attacks against CV models, gradient-based attack generation methods are less popular in the NLP domain. HOTFLIP (Ebrahimi et al., 2018) is one of the most representative gradient-based attack methods by leveraging gradients to estimate the impact of character and/or word-level substitutions on NLP models. However, HOTFLIP neglects the optimality of site selection in the discrete character/token space and ignores the constraint on the post-attacking text fluency (to preserve readability) (Ren et al., 2019). By contrast, this work cooptimizes the selections of perturbation sites and tokens, and leverages a perplexity-guided loss to maintain the fluency of adversarial texts. Another attack method GBDA (Guo et al., 2021) models the token replacement operation as a probability distribution which is optimized using gradients. However, acquiring this probability distribution is accompanied with high computation and memory costs. By contrast, our work can achieve comparable or better performance with higher efficiency.
        - citations: 
            Javid Ebrahimi, Anyi Rao, Daniel Lowd, and Dejing Dou. Hotflip: White-box adversarial examples for text classification. In Proceedings of the 56th Annual Meeting of the Association for Computational Linguistics (Volume 2: Short Papers), pp. 31-36, 2018.
            Shuhuai Ren, Yihe Deng, Kun He, and Wanxiang Che. Generating natural language adversarial examples through probability weighted word saliency. In ACL, 2019.
            Chuan Guo, Alexandre Sablayrolles, Herv ́ e J ́ egou, and Douwe Kiela. Gradient-based adversarial attacks against text transformers. In Proceedings of the 2021 Conference on Empirical Methods in Natural Language Processing, pp. 5747-5757, 2021.
    RESULT:
        [
            {
                "entity name": "TextGrad: Advancing Robustness Evaluation in NLP by Gradient-Driven Optimization",
                "entity type": "paper",
                "timestamp": null,
                "description": null
            },
            {
                "entity name": "adversarial attacks in NLP",
                "entity type": "domain",
                "timestamp": null,
                "description": null
            },
            {
                "entity name": "gradient-based attack generation methods",
                "entity type": "method",
                "timestamp": null,
                "description": null
            },
            {
                "entity name": "HOTFLIP",
                "entity type": "method",
                "timestamp": null,
                "description": "one of the most representative gradient-based attack methods by leveraging gradients to estimate the impact of character and/or word-level substitutions on NLP models"
            },
            {
                "entity name": "Hotflip: White-box adversarial examples for text classification",
                "entity type": "paper",
                "timestamp": "2018",
                "description": null
            },
            {
                "entity name": "the optimality of site selection in the discrete character/token space",
                "entity type": "problem",
                "timestamp": null,
                "description": null
            },
            {
                "entity name": "the post-attacking text fluency",
                "entity type": "problem",
                "timestamp": null,
                "description": "a constrant to preserve readability"
            },
            {
                "entity name": "Generating natural language adversarial examples through probability weighted word saliency",
                "entity type": "paper",
                "timestamp": "2019",
                "description": null
            },
            {
                "entity name": "GBDA",
                "entity type": "method",
                "timestamp": null,
                "description": "models the token replacement operation as a probability distribution which is optimized using gradients"
            },
            {
                "entity name": "Gradient-based adversarial attacks against text transformers",
                "entity type": "paper",
                "timestamp": "2021",
                "description": null
            },
            {
                "entity name": "efficiency in attack methods",
                "entity type": "problem",
                "timestamp": null,
                "description": "high computation and memory costs decrease the efficiency"
            }
        ]'''       
EXTRACT_RELATED_WORK_RELATION = '''TASK: The text provided to you including a paper excerpt, references it mentions, and the entities extracted from it. Please extract the relations of the entities.
REQUIREMENTS:
1. Please ensure that both entities in the relation entry you extract have already appeared in the entity list.
2. Make sure you look for the corresponding relationships for each entity.
3. format requirement:
    {
        "entity1": entity1,
        "relation": description of the relation between Entity1 and Entity2 extracted from the text, without directionality.
        "entity2": entity2
    },
    the final result should be a list consisting of the relations. Please return a valid JSON object without adding any extra tags or explanations.
EXAMPLE:
    TEXT:
        - paper title: TextGrad: Advancing Robustness Evaluation in NLP by Gradient-Driven Optimization
        - excerpt theme: Adversarial attacks in NLP.
        - content: Different from attacks against CV models, gradient-based attack generation methods are less popular in the NLP domain. HOTFLIP (Ebrahimi et al., 2018) is one of the most representative gradient-based attack methods by leveraging gradients to estimate the impact of character and/or word-level substitutions on NLP models. However, HOTFLIP neglects the optimality of site selection in the discrete character/token space and ignores the constraint on the post-attacking text fluency (to preserve readability) (Ren et al., 2019). By contrast, this work cooptimizes the selections of perturbation sites and tokens, and leverages a perplexity-guided loss to maintain the fluency of adversarial texts. Another attack method GBDA (Guo et al., 2021) models the token replacement operation as a probability distribution which is optimized using gradients. However, acquiring this probability distribution is accompanied with high computation and memory costs. By contrast, our work can achieve comparable or better performance with higher efficiency.
        - citations: 
            Javid Ebrahimi, Anyi Rao, Daniel Lowd, and Dejing Dou. Hotflip: White-box adversarial examples for text classification. In Proceedings of the 56th Annual Meeting of the Association for Computational Linguistics (Volume 2: Short Papers), pp. 31-36, 2018.
            Shuhuai Ren, Yihe Deng, Kun He, and Wanxiang Che. Generating natural language adversarial examples through probability weighted word saliency. In ACL, 2019.
            Chuan Guo, Alexandre Sablayrolles, Herv ́ e J ́ egou, and Douwe Kiela. Gradient-based adversarial attacks against text transformers. In Proceedings of the 2021 Conference on Empirical Methods in Natural Language Processing, pp. 5747-5757, 2021.
    ENTITIES:
        [
            {
                "entity name": "TextGrad: Advancing Robustness Evaluation in NLP by Gradient-Driven Optimization",
                "entity type": "paper",
                "timestamp": null,
                "description": null
            },
            {
                "entity name": "adversarial attacks in NLP",
                "entity type": "domain",
                "timestamp": null,
                "description": null
            },
            {
                "entity name": "gradient-based attack generation methods",
                "entity type": "method",
                "timestamp": null,
                "description": null
            },
            {
                "entity name": "HOTFLIP",
                "entity type": "method",
                "timestamp": null,
                "description": "one of the most representative gradient-based attack methods by leveraging gradients to estimate the impact of character and/or word-level substitutions on NLP models"
            },
            {
                "entity name": "Hotflip: White-box adversarial examples for text classification",
                "entity type": "paper",
                "timestamp": "2018",
                "description": null
            },
            {
                "entity name": "the optimality of site selection in the discrete character/token space",
                "entity type": "problem",
                "timestamp": null,
                "description": null
            },
            {
                "entity name": "the post-attacking text fluency",
                "entity type": "problem",
                "timestamp": null,
                "description": "a constrant to preserve readability"
            },
            {
                "entity name": "Generating natural language adversarial examples through probability weighted word saliency",
                "entity type": "paper",
                "timestamp": "2019",
                "description": null
            },
            {
                "entity name": "GBDA",
                "entity type": "method",
                "timestamp": null,
                "description": "models the token replacement operation as a probability distribution which is optimized using gradients"
            },
            {
                "entity name": "Gradient-based adversarial attacks against text transformers",
                "entity type": "paper",
                "timestamp": "2021",
                "description": null
            },
            {
                "entity name": "efficiency in attack methods",
                "entity type": "problem",
                "timestamp": null,
                "description": "high computation and memory costs decrease the efficiency"
            }
        ]
    RESULTS:
        [
            {
                "entity1": "TextGrad: Advancing Robustness Evaluation in NLP by Gradient-Driven Optimization",
                "relation": "related to",
                "entity2": "adversarial attacks in NLP"
            },
            {
                "entity1": "gradient-based attack generation methods",
                "relation": "is applied in",
                "entity2": "adversarial attacks in NLP"
            },
            {
                "entity1": "Hotflip: White-box adversarial examples for text classification",
                "relation": "proposes",
                "entity2": "HOTFLIP"
            },
            {
                "entity1": "HOTFLIP",
                "relation": "is one of",
                "entity2": "gradient-based attack generation methods"
            },
            {
                "entity1": "HOTFLIP",
                "relation": "has problem in",
                "entity2": "the optimality of site selection in the discrete character/token space"
            },
            {
                "entity1": "HOTFLIP",
                "relation": "has problem in",
                "entity2": "the post-attacking text fluency"
            },
            {
                "entity1": "Generating natural language adversarial examples through probability weighted word saliency",
                "relation": "mentions",
                "entity2": "the post-attacking text fluency"
            },
            {
                "entity1": "TextGrad: Advancing Robustness Evaluation in NLP by Gradient-Driven Optimization",
                "relation": "addresses",
                "entity2": "the optimality of site selection in the discrete character/token space"
            },
            {
                "entity1": "TextGrad: Advancing Robustness Evaluation in NLP by Gradient-Driven Optimization",
                "relation": "addresses",
                "entity2": "the post-attacking text fluency"
            },
            {
                "entity1": "Gradient-based adversarial attacks against text transformers",
                "relation": "proposes",
                "entity2": "GBDA"
            },
            {
                "entity1": "GBDA",
                "relation": "is one of",
                "entity2": "gradient-based attack generation methods"
            },
            {
                "entity1": "GBDA",
                "relation": "has problem in",
                "entity2": "efficiency in attack methods"
            },
            {
                "entity1": "TextGrad: Advancing Robustness Evaluation in NLP by Gradient-Driven Optimization",
                "relation": "addresses",
                "entity2": "efficiency in attack methods"
            }
        ]'''

REVIEWER = '''You are a reviewer responsible for evaluating the results of entity and relationship extraction. Please assess whether the existing extraction results meet the requirements based on the text and criteria. If they do not meet the requirements, give your modification advice. If you are satisfied at them, then only reply with 'PASS'.
TEXT:
    - paper title: {title}
    - content: {content}
CRITERIA:
    1. The entity type should be only chosen from method, problem, domain, and paper.
    2. The entities extracted should be the keywords to answer the following questions:  a. Which papers are cited in this text? Considering their titles, why are these papers cited? b. What fields, methods, and technologies are mentioned in this text? How are they related to each other?
    3. The entity mentioned in a relation entry should already exist in the entity list.
    4. The relation of the two entities should be clear and explict.
    5. There should not be any discrete entity node or entity node with duplicate name.
    6. The paper itself MUST be included in the entity list with proper relations.
    7. Your comments should be as concise as possible. 
EXTRACTION RESULT:
{result}'''


EDITOR = '''You are a editor responsible for revising the text based on the reviewers' comments and following rules.
RULES: 
    1. The entity type should be only chosen from method, problem, domain, and paper.
    2. The entity mentioned in a relation entry should already exist in the entity list.
    3. format requirement:
    the entity node structure: 
        {{
            "entity name": name,
            "entity type": type,
            "timestamp": occuring time of the entity mentioned in the content (null if not mentioned),
            "description": abstract or description of the entity in the paper (if it is not a paper entity and there is no further description in the text, then it is null).
        }}, 
    the relation: 
        {{
            "entity1": entity1,
            "relation": description of the relation between Entity1 and Entity2 extracted from the text, without directionality.
            "entity2": entity2
        }}, 
    the final result should be a list that includes both entity and relation components with following JSON format. Please return a valid JSON object without adding any extra tags or explanations.
        [
            {{"entity": List[Dict]}},
            {{"relation": List[Dict]}}
        ]
REVIEWER COMMENTS:
    {review}
HISTORY RESULT:
    {history}'''
    
FIND_SIMILAR_ENTITY = '''Based on the entity names provided below, identify two or more entities with similar meanings and respond in the specified JSON format. Note: For example, if "LLMs," "Large Language Models," and "Large Language Models (LLMs)" are the entities that meet the criteria, you should respond with [["LLMs", "Large Language Models", "Large Language Models (LLMs)"]].
Format requirement: 
1. If there is actually any redundant entities, your result should be a list containing all groups of similar entities, with each group represented as a list.
2. If there is no redundant entities, your result should be an empty list.
ENTITY LIST:
{entity}'''

MERGE_SIMILAR_ENTITY = '''These entities are considered to have similar meanings in their names. Now you need to merge them based on their specific information, that is, to generate a new entity node based on their information. You need to return your results in the following format:
{{
    "entity name": the new name,
    "entity type": keep it unchanged if all these entities are in the same entity type, otherwise choose the most suitable one from 'method', 'problem', and 'domain'.
    "timestamp": null,
    "description": summarize and extract based on the existing descriptions of these entities; if there is none, then keep it unchanged.
}}
ENTITIES WITH SIMILAR MEANINGS:
{entity}'''

CREATE_NODE = '''Identify the entity: {entity} within the content and determine its entity type based on the context. The entity type should be one of the following: 'method', 'problem', 'domain', or 'paper'. Please respond using the format below.
{{
    "entity name": "{entity}",
    "entity type": select from 'method', 'problem', and 'domain',
    "timestamp": null,
    "description": description of the entity, extracted from the context. null if there is not enough information.
}}
Make sure to return a valid JSON format result.
CONTENT:
{content}'''
