# extractors/title_extractor.py
import fitz
from api_client import ask_for_openai


def extract_title(pdf_path) -> str:
    """
    获取PDF的标题。
    参数:
    - doc: fitz.Document，PDF文档对象
    返回值:
    - str: PDF的标题
    """
    doc = fitz.open(pdf_path)
    first_page = doc.load_page(0)
    text = first_page.get_text("text")
    pre_prompt = ("These are the first few lines of a certain paper, possibly including the page header, title, "
                  "author, and other content.")
    post_prompt = "Based on this, what is the title of this paper. Do not use any additional words or phrases."
    title = ask_for_openai(content=text, pre_prompt=pre_prompt, post_prompt=post_prompt)
    doc.close()
    return title
