import os

from process_pdf import process_pdf


def main():
    # query_text = "Disc-medllm:Bridging general large language models and real-world medical consultation."
    # reference = search_and_format_reference(query_text)

    data_dir = 'data'  # 源目录
    output_dir = 'output'  # 输出目录

    # 如果输出目录不存在，创建它
    os.makedirs(output_dir, exist_ok=True)

    # 遍历data目录下的所有.pdf文件
    for root, _, files in os.walk(data_dir):
        for file in files:
            if file.endswith('.pdf'):
                pdf_file_path = os.path.join(root, file)
                process_pdf(pdf_file_path, output_dir)


if __name__ == "__main__":
    main()
