import re
from utils import check_if_APA


def extract_refs_from_rw(rw_content, rf_content):
    # rw_content 是一个字典，key是subtitle，value是content
    # 只考虑了[1]这种形式的参考文献
    # 首先从rw_content中找出所有[1]或者[2, 3]这种形式的参考文献
    # print("rw_content:", rw_content)
    print("rf_content:", rf_content)
    print("len(rf_content):", len(rf_content))
    rf_list = []
    if_APA = check_if_APA(rf_content[0])

    if not if_APA:
        # 遍历rw_content里面的所有元素
        for subtitle, content in rw_content.items():
            # 从content中找到所有的参考文献
            # 类似[1]或者[2,3]这样的形式就对应一个或者一组参考文献, 两个中括号里面不能有其他中括号
            # 这里的正则表达式是\[[^\[\]]*?\]
            refs = re.findall(r'\[[^\[\]]*?\]', content)
            # print("refs:", refs)
            # 对于每一个参考文献，去掉[和]之后就是参考文献的序号
            for ref in refs:
                ref = ref[1:-1]
                # 如果ref是一个数字，那么就是一个参考文献
                if ref.isdigit():
                    rf_list.append(rf_content[int(ref) - 1])
                # 如果ref是一个数字的列表，那么就是多个参考文献
                elif ',' in ref:
                    for r in ref.split(','):
                        rf_list.append(rf_content[int(r) - 1])
    else:
        # 如(Wu et al., 2023b; Singhal et al., 2023a; Yang et al., 2023)这种形式的参考文献
        # 遍历rw_content里面的所有元素
        for subtitle, content in rw_content.items():
            # 从content中找到所有的参考文献
            # 类似(Wu et al., 2023b; Singhal et al., 2023a; Yang et al., 2023)这样的形式就对应一个或者一组参考文献, 其中必须有2013这样的年份, 两个括号里面不能有其他括号
            # 这里的正则表达式是\([^\(\)]*?20[12][^\(\)]*?\)
            refs = re.findall(r'\([^\(\)]*?20[12][^\(\)]*?\)', content)
            # print("refs:", refs)
            # 对于每一个参考文献，去掉(和)之后就是参考文献的序号
            for ref in refs:
                ref = ref[1:-1]
                # 按照;分割
                for r in ref.split(';'):
                    rf_list.append(r)

    # 去重
    rf_list = list(set(rf_list))
    # print("rf_list:", rf_list)

    return rf_list
