# /utils/check_section_title.py

import re
from utils import simplify_string


def check_if_section_title(line, title):
    # 参数: title: str 需要检查的章节标题
    #       line: str 当前行
    # 返回: bool 是否是章节标题, match: 正则表达式匹配结果
    # 如果 line_lower 以 title 结尾

    simplified_line = simplify_string(line)
    simplified_title = simplify_string(title)
    is_section_title = False
    match = None

    if simplified_line.endswith(simplified_title):
        # 前面不超过2个字符，那么认为是章节标题
        if len(simplified_line) - len(simplified_title) <= 2:
            is_section_title = True
            simplified_line = simplified_title
        # 前面的内容满足 [数字.数字.] 其中最后一个. 可以没有, 也认为是章节标题
        else:
            # 用正则表达式匹配 (\d+\.)*\d+\.?)
            match = re.match(r'((\d+\.)*\d+\.?)\s+(.*)', line)
            if match:
                is_section_title = True
                simplified_line = simplified_title


    # 如果 line_lower 中含有 title，并且后面跟一个冒号，并且前面不超过2个字符，那么认为是章节标题
    else:
        with_colon = title + ':'
        if with_colon in simplified_line and simplified_line.index(with_colon) <= 2:
            is_section_title = True
            simplified_title = simplified_title

    return is_section_title, title, match
